/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.common.source.arrow;

import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public class SeaTunnelDataTypeHolder {
    private final String filedName;
    private final int flag;

    public SeaTunnelDataTypeHolder(String filedName, int flag) {
        this.filedName = filedName;
        this.flag = flag;
    }

    public String getFiledName() {
        return this.filedName;
    }

    public int getFlag() {
        return this.flag;
    }

    public SeaTunnelDataType getSeatunnelDataType() {
        switch (this.filedName) {
            case "boolean": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "byte": {
                return BasicType.BYTE_TYPE;
            }
            case "short": {
                return BasicType.SHORT_TYPE;
            }
            case "int": {
                return BasicType.INT_TYPE;
            }
            case "long": {
                return BasicType.LONG_TYPE;
            }
            case "float": {
                return BasicType.FLOAT_TYPE;
            }
            case "double": {
                return BasicType.DOUBLE_TYPE;
            }
            case "string1": 
            case "string2": 
            case "string3": {
                return BasicType.STRING_TYPE;
            }
            case "decimal": {
                return new DecimalType(10, 2);
            }
            case "timestamp1": 
            case "timestamp2": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "time": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "date1": 
            case "date2": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "array1": {
                return ArrayType.INT_ARRAY_TYPE;
            }
            case "array2": {
                return ArrayType.LOCAL_DATE_TIME_ARRAY_TYPE;
            }
            case "map": {
                return new MapType((SeaTunnelDataType)BasicType.STRING_TYPE, (SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
            }
        }
        return null;
    }
}

