/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.auth;

import com.aliyun.datahub.shaded.org.apache.commons.lang3.StringUtils;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class Authorization {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_HASH = "HmacSHA1";

    public static String getAkAuthorization(Request request) {
        String canonicalURL = Authorization.getCanonicalURI(request.getUrlPath());
        String canonicalQueryString = request.getQueryStrings();
        String canonicalHeaderString = Authorization.getCanonicalHeaders(Authorization.getSortedHeadersToSign(request.getHeaders()));
        String canonicalRequest = request.getMethod().toUpperCase() + "\n" + canonicalHeaderString + "\n" + canonicalURL;
        if (!StringUtils.isEmpty(canonicalQueryString)) {
            canonicalRequest = canonicalRequest + "?" + canonicalQueryString;
        }
        String signature = Authorization.HMAC1Sign(request.getAccessKey(), canonicalRequest);
        return "DATAHUB " + request.getAccessId() + ":" + signature;
    }

    private static String HMAC1Sign(String accessKey, String canonicalRequest) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(accessKey.getBytes(), DEFAULT_HASH);
            Mac mac = Mac.getInstance(DEFAULT_HASH);
            mac.init(signingKey);
            return Base64.getEncoder().encodeToString(mac.doFinal(canonicalRequest.getBytes(DEFAULT_ENCODING))).trim();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String getCanonicalHeaders(Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> pairs = headers.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry<String, String> pair = pairs.next();
            if (pair.getKey().startsWith("x-datahub-")) {
                sb.append(pair.getKey());
                sb.append(":");
                sb.append(pair.getValue());
            } else {
                sb.append(pair.getValue());
            }
            if (!pairs.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String getCanonicalURI(String urlPath) {
        return urlPath;
    }

    private static SortedMap<String, String> getSortedHeadersToSign(Map<String, List<String>> headers) {
        TreeMap<String, String> sortedHeaders = new TreeMap<String, String>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String lowerKey = entry.getKey().toLowerCase();
            if (!lowerKey.equalsIgnoreCase("Content-Type") && !lowerKey.equalsIgnoreCase("Date") && !lowerKey.startsWith("x-datahub-") || entry.getValue().isEmpty()) continue;
            sortedHeaders.put(lowerKey, entry.getValue().get(0));
        }
        if (!sortedHeaders.containsKey("Content-Type".toLowerCase())) {
            sortedHeaders.put("Content-Type".toLowerCase(), "");
        }
        return sortedHeaders;
    }

    public static class Request {
        private String accessId;
        private String accessKey;
        private String urlPath;
        private String method;
        private Map<String, List<String>> headers;
        private String queryStrings;

        public String getAccessId() {
            return this.accessId;
        }

        public Request setAccessId(String accessId) {
            this.accessId = accessId;
            return this;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public Request setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public String getUrlPath() {
            return this.urlPath;
        }

        public Request setUrlPath(String urlPath) {
            this.urlPath = urlPath;
            return this;
        }

        public String getMethod() {
            return this.method;
        }

        public Request setMethod(String method) {
            this.method = method;
            return this;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public Request setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public String getQueryStrings() {
            return this.queryStrings;
        }

        public Request setQueryStrings(String queryStrings) {
            this.queryStrings = queryStrings;
            return this;
        }
    }
}

