/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.converter;

import com.aliyun.datahub.client.util.CrcUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MessageOutputStream
extends DataOutputStream {
    private boolean enablePbCrc;

    public MessageOutputStream(boolean enablePbCrc) {
        this(1024);
        this.enablePbCrc = enablePbCrc;
    }

    public MessageOutputStream(int capacity) {
        super(new FramedBuffer(capacity));
    }

    private FramedBuffer getFramedBuffer() {
        return (FramedBuffer)this.out;
    }

    public byte[] toByteArray() {
        FramedBuffer buffer = this.getFramedBuffer();
        if (this.enablePbCrc) {
            buffer.doCrc();
        }
        return buffer.toByteArray();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.getFramedBuffer().writeTo(out);
    }

    private static class FramedBuffer
    extends ByteArrayOutputStream {
        private static final int FRAME_HEADER_SIZE = 8;
        private static final int FRAME_PACK_PAD_SIZE = 12;

        public FramedBuffer(int capacity) {
            super(capacity + 8);
            this.reset();
        }

        @Override
        public synchronized void writeTo(OutputStream out) throws IOException {
            super.writeTo(out);
        }

        @Override
        public synchronized void reset() {
            this.write("DHUB".getBytes(), 0, 4);
            this.setCrc32(0);
            this.count = 8;
        }

        public void doCrc() {
            this.setCrc32(CrcUtils.getCrc32(this.buf, 12, this.count - 12));
        }

        public void setCrc32(int crc32) {
            this.buf[4] = (byte)(crc32 >>> 24 & 0xFF);
            this.buf[5] = (byte)(crc32 >>> 16 & 0xFF);
            this.buf[6] = (byte)(crc32 >>> 8 & 0xFF);
            this.buf[7] = (byte)(crc32 & 0xFF);
        }
    }
}

