/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.datahub.sink;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.model.PutRecordsResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.TupleRecordData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHubWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private static final Logger log = LoggerFactory.getLogger(DataHubWriter.class);
    private final DatahubClient dataHubClient;
    private final String project;
    private final String topic;
    private final Integer retryTimes;
    private final SeaTunnelRowType seaTunnelRowType;

    public DataHubWriter(SeaTunnelRowType seaTunnelRowType, String endpoint, String accessId, String accessKey, String project, String topic, Integer timeout, Integer retryTimes) {
        this.dataHubClient = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig(endpoint, new AliyunAccount(accessId, accessKey), true)).setHttpConfig(new HttpConfig().setCompressType(HttpConfig.CompressType.LZ4).setConnTimeout(timeout)).build();
        this.seaTunnelRowType = seaTunnelRowType;
        this.project = project;
        this.topic = topic;
        this.retryTimes = retryTimes;
    }

    public void write(SeaTunnelRow element) {
        String[] fieldNames = this.seaTunnelRowType.getFieldNames();
        Object[] fields = element.getFields();
        ArrayList<RecordEntry> recordEntries = new ArrayList<RecordEntry>();
        RecordSchema recordSchema = this.dataHubClient.getTopic(this.project, this.topic).getRecordSchema();
        for (int i = 0; i < fieldNames.length; ++i) {
            TupleRecordData data = new TupleRecordData(recordSchema);
            data.setField(fieldNames[i], fields[i]);
            RecordEntry recordEntry = new RecordEntry();
            recordEntry.setRecordData(data);
            recordEntries.add(recordEntry);
        }
        try {
            PutRecordsResult result = this.dataHubClient.putRecords(this.project, this.topic, recordEntries);
            int failedRecordCount = result.getFailedRecordCount();
            if (failedRecordCount > 0) {
                log.info("begin to retry for putting failed record");
                if (this.retry(result.getFailedRecords(), this.retryTimes, this.project, this.topic)) {
                    log.info("retry putting record success");
                } else {
                    log.info("retry putting record failed");
                }
            } else {
                log.info("put record success");
            }
        }
        catch (DatahubClientException e) {
            log.error("requestId:" + e.getRequestId() + "\tmessage:" + e.getErrorMessage());
        }
    }

    public void close() throws IOException {
    }

    private boolean retry(List<RecordEntry> records, int retryNums, String project, String topic) {
        boolean success;
        block1: {
            success = false;
            if (retryNums == 0) break block1;
            --retryNums;
            PutRecordsResult recordsResult = this.dataHubClient.putRecords(project, topic, records);
            if (recordsResult.getFailedRecordCount() > 0) {
                this.retry(recordsResult.getFailedRecords(), retryNums, project, topic);
            }
            success = true;
        }
        return success;
    }
}

