/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.sink;

import com.google.auto.service.AutoService;
import java.io.IOException;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.config.DingTalkConfig;
import org.apache.seatunnel.connectors.seatunnel.exception.DingTalkConnectorException;
import org.apache.seatunnel.connectors.seatunnel.sink.DingTalkWriter;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSink.class})
public class DingTalkSink
extends AbstractSimpleSink<SeaTunnelRow, Void> {
    private Config pluginConfig;
    private SeaTunnelRowType seaTunnelRowType;

    public String getPluginName() {
        return "DingTalk";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        if (pluginConfig.getIsNull(DingTalkConfig.URL.key())) {
            throw new DingTalkConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("Config must include column : %s", DingTalkConfig.URL.key()));
        }
        if (pluginConfig.getIsNull(DingTalkConfig.SECRET.key())) {
            throw new DingTalkConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("Config must include column : %s", DingTalkConfig.SECRET.key()));
        }
        this.pluginConfig = pluginConfig;
    }

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new DingTalkWriter(this.pluginConfig.getString(DingTalkConfig.URL.key()), this.pluginConfig.getString(DingTalkConfig.SECRET.key()));
    }
}

