/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.easysearch.serialize.index.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.easysearch.serialize.index.IndexSerializer;

public class VariableIndexSerializer
implements IndexSerializer {
    private final String index;
    private final Map<String, Integer> fieldIndexMap;
    private final String nullDefault = "null";

    public VariableIndexSerializer(SeaTunnelRowType seaTunnelRowType, String index, List<String> fieldNames) {
        this.index = index;
        String[] rowFieldNames = seaTunnelRowType.getFieldNames();
        this.fieldIndexMap = new HashMap<String, Integer>(rowFieldNames.length);
        for (int i = 0; i < rowFieldNames.length; ++i) {
            if (!fieldNames.contains(rowFieldNames[i])) continue;
            this.fieldIndexMap.put(rowFieldNames[i], i);
        }
    }

    @Override
    public String serialize(SeaTunnelRow row) {
        String indexName = this.index;
        for (Map.Entry<String, Integer> fieldIndexEntry : this.fieldIndexMap.entrySet()) {
            String fieldName = fieldIndexEntry.getKey();
            int fieldIndex = fieldIndexEntry.getValue();
            String value = this.getValue(fieldIndex, row);
            indexName = indexName.replace(String.format("${%s}", fieldName), value);
        }
        return indexName.toLowerCase();
    }

    private String getValue(int fieldIndex, SeaTunnelRow row) {
        Object valueObj = row.getField(fieldIndex);
        if (valueObj == null) {
            return "null";
        }
        return valueObj.toString();
    }
}

