/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.easysearch.source;

import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.easysearch.source.EasysearchSourceReader;
import org.apache.seatunnel.connectors.seatunnel.easysearch.source.EasysearchSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.easysearch.source.EasysearchSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.easysearch.source.EasysearchSourceState;

public class EasysearchSource
implements SeaTunnelSource<SeaTunnelRow, EasysearchSourceSplit, EasysearchSourceState>,
SupportParallelism,
SupportColumnProjection {
    private final ReadonlyConfig pluginConfig;
    private final List<String> source;
    private final CatalogTable catalogTable;

    public EasysearchSource(ReadonlyConfig pluginConfig, List<String> source, CatalogTable catalogTable) {
        this.pluginConfig = pluginConfig;
        this.source = source;
        this.catalogTable = catalogTable;
    }

    public String getPluginName() {
        return "Easysearch";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }

    public SourceReader<SeaTunnelRow, EasysearchSourceSplit> createReader(SourceReader.Context readerContext) {
        return new EasysearchSourceReader(readerContext, this.pluginConfig, this.catalogTable.getSeaTunnelRowType());
    }

    public SourceSplitEnumerator<EasysearchSourceSplit, EasysearchSourceState> createEnumerator(SourceSplitEnumerator.Context<EasysearchSourceSplit> enumeratorContext) {
        return new EasysearchSourceSplitEnumerator(enumeratorContext, this.pluginConfig, this.source);
    }

    public SourceSplitEnumerator<EasysearchSourceSplit, EasysearchSourceState> restoreEnumerator(SourceSplitEnumerator.Context<EasysearchSourceSplit> enumeratorContext, EasysearchSourceState sourceState) {
        return new EasysearchSourceSplitEnumerator(enumeratorContext, sourceState, this.pluginConfig, this.source);
    }
}

