/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.node.usage;

import java.io.IOException;
import java.util.Map;
import org.easysearch.action.support.nodes.BaseNodeResponse;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.common.xcontent.XContentBuilder;

public class NodeUsage
extends BaseNodeResponse
implements ToXContentFragment {
    private final long timestamp;
    private final long sinceTime;
    private final Map<String, Long> restUsage;
    private final Map<String, Object> aggregationUsage;

    public NodeUsage(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readLong();
        this.sinceTime = in.readLong();
        this.restUsage = (Map)in.readGenericValue();
        this.aggregationUsage = (Map)in.readGenericValue();
    }

    public NodeUsage(DiscoveryNode node, long timestamp, long sinceTime, Map<String, Long> restUsage, Map<String, Object> aggregationUsage) {
        super(node);
        this.timestamp = timestamp;
        this.sinceTime = sinceTime;
        this.restUsage = restUsage;
        this.aggregationUsage = aggregationUsage;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSinceTime() {
        return this.sinceTime;
    }

    public Map<String, Long> getRestUsage() {
        return this.restUsage;
    }

    public Map<String, Object> getAggregationUsage() {
        return this.aggregationUsage;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("since", this.sinceTime);
        if (this.restUsage != null) {
            builder.field("rest_actions");
            builder.map(this.restUsage);
        }
        if (this.aggregationUsage != null) {
            builder.field("aggregations");
            builder.map(this.aggregationUsage);
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.timestamp);
        out.writeLong(this.sinceTime);
        out.writeGenericValue(this.restUsage);
        out.writeGenericValue(this.aggregationUsage);
    }
}

