/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.shards;

import java.io.IOException;
import java.util.Objects;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.action.support.master.MasterNodeReadRequest;
import org.easysearch.common.Nullable;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;

public class ClusterSearchShardsRequest
extends MasterNodeReadRequest<ClusterSearchShardsRequest>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private IndicesOptions indicesOptions = IndicesOptions.lenientExpandOpen();

    public ClusterSearchShardsRequest() {
    }

    public ClusterSearchShardsRequest(String ... indices) {
        this.indices(indices);
    }

    public ClusterSearchShardsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public ClusterSearchShardsRequest indices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (int i = 0; i < indices.length; ++i) {
            Objects.requireNonNull(indices[i], "indices[" + i + "] must not be null");
        }
        this.indices = indices;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public ClusterSearchShardsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public String routing() {
        return this.routing;
    }

    public ClusterSearchShardsRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public ClusterSearchShardsRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public ClusterSearchShardsRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }
}

