/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.snapshots.restore;

import java.io.IOException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.cluster.snapshots.restore.RestoreClusterStateListener;
import org.easysearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.easysearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.TransportMasterNodeAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.snapshots.RestoreService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportRestoreSnapshotAction
extends TransportMasterNodeAction<RestoreSnapshotRequest, RestoreSnapshotResponse> {
    private final RestoreService restoreService;

    @Inject
    public TransportRestoreSnapshotAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RestoreService restoreService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/snapshot/restore", transportService, clusterService, threadPool, actionFilters, RestoreSnapshotRequest::new, indexNameExpressionResolver);
        this.restoreService = restoreService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected RestoreSnapshotResponse read(StreamInput in) throws IOException {
        return new RestoreSnapshotResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(RestoreSnapshotRequest request, ClusterState state) {
        ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (blockException != null) {
            return blockException;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected void masterOperation(RestoreSnapshotRequest request, ClusterState state, ActionListener<RestoreSnapshotResponse> listener) {
        this.restoreService.restoreSnapshot(request, ActionListener.delegateFailure(listener, (delegatedListener, restoreCompletionResponse) -> {
            if (restoreCompletionResponse.getRestoreInfo() == null && request.waitForCompletion()) {
                RestoreClusterStateListener.createAndRegisterListener(this.clusterService, restoreCompletionResponse, delegatedListener);
            } else {
                delegatedListener.onResponse(new RestoreSnapshotResponse(restoreCompletionResponse.getRestoreInfo()));
            }
        }));
    }
}

