/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.forcemerge;

import java.io.IOException;
import java.util.Arrays;
import org.easysearch.CompatibleESVersion;
import org.easysearch.Version;
import org.easysearch.action.support.broadcast.BroadcastRequest;
import org.easysearch.common.Nullable;
import org.easysearch.common.UUIDs;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;

public class ForceMergeRequest
extends BroadcastRequest<ForceMergeRequest> {
    private int maxNumSegments = -1;
    private boolean onlyExpungeDeletes = false;
    private boolean flush = true;
    private static final Version FORCE_MERGE_UUID_VERSION = CompatibleESVersion.V_7_10_2;
    @Nullable
    private final String forceMergeUUID;

    public ForceMergeRequest(String ... indices) {
        super(indices);
        this.forceMergeUUID = UUIDs.randomBase64UUID();
    }

    public ForceMergeRequest(StreamInput in) throws IOException {
        super(in);
        this.maxNumSegments = in.readInt();
        this.onlyExpungeDeletes = in.readBoolean();
        this.flush = in.readBoolean();
        this.forceMergeUUID = in.getVersion().onOrAfter(FORCE_MERGE_UUID_VERSION) ? in.readOptionalString() : null;
    }

    public int maxNumSegments() {
        return this.maxNumSegments;
    }

    public ForceMergeRequest maxNumSegments(int maxNumSegments) {
        this.maxNumSegments = maxNumSegments;
        return this;
    }

    public boolean onlyExpungeDeletes() {
        return this.onlyExpungeDeletes;
    }

    public ForceMergeRequest onlyExpungeDeletes(boolean onlyExpungeDeletes) {
        this.onlyExpungeDeletes = onlyExpungeDeletes;
        return this;
    }

    @Nullable
    public String forceMergeUUID() {
        return this.forceMergeUUID;
    }

    public boolean flush() {
        return this.flush;
    }

    public ForceMergeRequest flush(boolean flush) {
        this.flush = flush;
        return this;
    }

    @Override
    public String getDescription() {
        return "Force-merge indices " + Arrays.toString(this.indices()) + ", maxSegments[" + this.maxNumSegments + "], onlyExpungeDeletes[" + this.onlyExpungeDeletes + "], flush[" + this.flush + "]";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.maxNumSegments);
        out.writeBoolean(this.onlyExpungeDeletes);
        out.writeBoolean(this.flush);
        if (out.getVersion().onOrAfter(FORCE_MERGE_UUID_VERSION)) {
            out.writeOptionalString(this.forceMergeUUID);
        }
    }

    public String toString() {
        return "ForceMergeRequest{maxNumSegments=" + this.maxNumSegments + ", onlyExpungeDeletes=" + this.onlyExpungeDeletes + ", flush=" + this.flush + "}";
    }

    public static final class Defaults {
        public static final int MAX_NUM_SEGMENTS = -1;
        public static final boolean ONLY_EXPUNGE_DELETES = false;
        public static final boolean FLUSH = true;
    }
}

