/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.mapping.get;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.easysearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.info.TransportClusterInfoAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.metadata.MappingMetadata;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.collect.ImmutableOpenMap;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.indices.IndicesService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportGetMappingsAction
extends TransportClusterInfoAction<GetMappingsRequest, GetMappingsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetMappingsAction.class);
    private final IndicesService indicesService;

    @Inject
    public TransportGetMappingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super("indices:admin/mappings/get", transportService, clusterService, threadPool, actionFilters, GetMappingsRequest::new, indexNameExpressionResolver);
        this.indicesService = indicesService;
    }

    @Override
    protected GetMappingsResponse read(StreamInput in) throws IOException {
        return new GetMappingsResponse(in);
    }

    @Override
    protected void doMasterOperation(GetMappingsRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetMappingsResponse> listener) {
        logger.trace("serving getMapping request based on version {}", (Object)state.version());
        try {
            ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> result = state.metadata().findMappings(concreteIndices, request.types(), this.indicesService.getFieldFilter());
            listener.onResponse(new GetMappingsResponse(result));
        }
        catch (IOException e) {
            listener.onFailure(e);
        }
    }
}

