/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.shards;

import java.io.IOException;
import java.util.EnumSet;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.action.support.master.MasterNodeReadRequest;
import org.easysearch.cluster.health.ClusterHealthStatus;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;

public class IndicesShardStoresRequest
extends MasterNodeReadRequest<IndicesShardStoresRequest>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpand();
    private EnumSet<ClusterHealthStatus> statuses = EnumSet.of(ClusterHealthStatus.YELLOW, ClusterHealthStatus.RED);

    public IndicesShardStoresRequest(String ... indices) {
        this.indices = indices;
    }

    public IndicesShardStoresRequest() {
    }

    public IndicesShardStoresRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        int nStatus = in.readVInt();
        this.statuses = EnumSet.noneOf(ClusterHealthStatus.class);
        for (int i = 0; i < nStatus; ++i) {
            this.statuses.add(ClusterHealthStatus.fromValue(in.readByte()));
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        out.writeVInt(this.statuses.size());
        for (ClusterHealthStatus status : this.statuses) {
            out.writeByte(status.value());
        }
        this.indicesOptions.writeIndicesOptions(out);
    }

    public IndicesShardStoresRequest shardStatuses(String ... shardStatuses) {
        this.statuses = EnumSet.noneOf(ClusterHealthStatus.class);
        for (String statusString : shardStatuses) {
            if ("all".equalsIgnoreCase(statusString)) {
                this.statuses = EnumSet.allOf(ClusterHealthStatus.class);
                return this;
            }
            this.statuses.add(ClusterHealthStatus.fromString(statusString));
        }
        return this;
    }

    public IndicesShardStoresRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public IndicesShardStoresRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public EnumSet<ClusterHealthStatus> shardStatuses() {
        return this.statuses;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

