/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.ingest;

import java.io.IOException;
import java.util.HashMap;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.cluster.node.info.NodeInfo;
import org.easysearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.easysearch.action.ingest.PutPipelineRequest;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.action.support.master.TransportMasterNodeAction;
import org.easysearch.client.OriginSettingClient;
import org.easysearch.client.node.NodeClient;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.ingest.IngestInfo;
import org.easysearch.ingest.IngestService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class PutPipelineTransportAction
extends TransportMasterNodeAction<PutPipelineRequest, AcknowledgedResponse> {
    private final IngestService ingestService;
    private final OriginSettingClient client;

    @Inject
    public PutPipelineTransportAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IngestService ingestService, NodeClient client) {
        super("cluster:admin/ingest/pipeline/put", transportService, ingestService.getClusterService(), threadPool, actionFilters, PutPipelineRequest::new, indexNameExpressionResolver);
        this.client = new OriginSettingClient(client, "ingest");
        this.ingestService = ingestService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(PutPipelineRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[0]);
        nodesInfoRequest.clear().addMetric(NodesInfoRequest.Metric.INGEST.metricName());
        this.client.admin().cluster().nodesInfo(nodesInfoRequest, ActionListener.wrap(nodeInfos -> {
            HashMap<DiscoveryNode, IngestInfo> ingestInfos = new HashMap<DiscoveryNode, IngestInfo>();
            for (NodeInfo nodeInfo : nodeInfos.getNodes()) {
                ingestInfos.put(nodeInfo.getNode(), nodeInfo.getInfo(IngestInfo.class));
            }
            this.ingestService.putPipeline(ingestInfos, request, listener);
        }, listener::onFailure));
    }

    @Override
    protected ClusterBlockException checkBlock(PutPipelineRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

