/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.resync;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.easysearch.Version;
import org.easysearch.action.support.replication.ReplicatedWriteRequest;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.index.shard.ShardId;
import org.easysearch.index.translog.Translog;

public final class ResyncReplicationRequest
extends ReplicatedWriteRequest<ResyncReplicationRequest> {
    private final long trimAboveSeqNo;
    private final Translog.Operation[] operations;
    private final long maxSeenAutoIdTimestampOnPrimary;

    ResyncReplicationRequest(StreamInput in) throws IOException {
        super(in);
        assert (Version.CURRENT.major <= 7);
        this.trimAboveSeqNo = in.readZLong();
        this.maxSeenAutoIdTimestampOnPrimary = in.readZLong();
        this.operations = in.readArray(Translog.Operation::readOperation, Translog.Operation[]::new);
    }

    public ResyncReplicationRequest(ShardId shardId, long trimAboveSeqNo, long maxSeenAutoIdTimestampOnPrimary, Translog.Operation[] operations) {
        super(shardId);
        this.trimAboveSeqNo = trimAboveSeqNo;
        this.maxSeenAutoIdTimestampOnPrimary = maxSeenAutoIdTimestampOnPrimary;
        this.operations = operations;
    }

    public long getTrimAboveSeqNo() {
        return this.trimAboveSeqNo;
    }

    public long getMaxSeenAutoIdTimestampOnPrimary() {
        return this.maxSeenAutoIdTimestampOnPrimary;
    }

    public Translog.Operation[] getOperations() {
        return this.operations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeZLong(this.trimAboveSeqNo);
        out.writeZLong(this.maxSeenAutoIdTimestampOnPrimary);
        out.writeArray(Translog.Operation::writeOperation, this.operations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResyncReplicationRequest that = (ResyncReplicationRequest)o;
        return this.trimAboveSeqNo == that.trimAboveSeqNo && this.maxSeenAutoIdTimestampOnPrimary == that.maxSeenAutoIdTimestampOnPrimary && Arrays.equals(this.operations, that.operations);
    }

    public int hashCode() {
        return Objects.hash(this.trimAboveSeqNo, this.maxSeenAutoIdTimestampOnPrimary, this.operations);
    }

    @Override
    public String toString() {
        return "TransportResyncReplicationAction.Request{shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + "', trimAboveSeqNo=" + this.trimAboveSeqNo + ", maxSeenAutoIdTimestampOnPrimary=" + this.maxSeenAutoIdTimestampOnPrimary + ", ops=" + this.operations.length + "}";
    }
}

