/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.support.master.info;

import java.io.IOException;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.action.support.master.MasterNodeReadRequest;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;

public abstract class ClusterInfoRequest<Request extends ClusterInfoRequest<Request>>
extends MasterNodeReadRequest<Request>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private String[] types = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public ClusterInfoRequest() {
    }

    public ClusterInfoRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.types = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.types);
        this.indicesOptions.writeIndicesOptions(out);
    }

    public Request indices(String ... indices) {
        this.indices = indices;
        return (Request)this;
    }

    public Request types(String ... types) {
        this.types = types;
        return (Request)this;
    }

    public Request indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return (Request)this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public String[] types() {
        return this.types;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }
}

