/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.indices;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.easysearch.cluster.health.ClusterHealthStatus;
import org.easysearch.common.Nullable;
import org.easysearch.common.ParseField;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.XContentParser;

public final class DataStream {
    private final String name;
    private final String timeStampField;
    private final List<String> indices;
    private final long generation;
    ClusterHealthStatus dataStreamStatus;
    @Nullable
    String indexTemplate;
    @Nullable
    String ilmPolicyName;
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField GENERATION_FIELD = new ParseField("generation", new String[0]);
    public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
    public static final ParseField INDEX_TEMPLATE_FIELD = new ParseField("template", new String[0]);
    public static final ParseField ILM_POLICY_FIELD = new ParseField("ilm_policy", new String[0]);
    private static final ConstructingObjectParser<DataStream, Void> PARSER = new ConstructingObjectParser("data_stream", args -> {
        String dataStreamName = (String)args[0];
        String timeStampField = (String)((Map)args[1]).get("name");
        List<String> indices = ((List)args[2]).stream().map(m3 -> (String)m3.get("index_name")).collect(Collectors.toList());
        Long generation = (Long)args[3];
        String statusStr = (String)args[4];
        ClusterHealthStatus status = ClusterHealthStatus.fromString(statusStr);
        String indexTemplate = (String)args[5];
        String ilmPolicy = (String)args[6];
        return new DataStream(dataStreamName, timeStampField, indices, generation, status, indexTemplate, ilmPolicy);
    });

    public DataStream(String name, String timeStampField, List<String> indices, long generation, ClusterHealthStatus dataStreamStatus, @Nullable String indexTemplate, @Nullable String ilmPolicyName) {
        this.name = name;
        this.timeStampField = timeStampField;
        this.indices = indices;
        this.generation = generation;
        this.dataStreamStatus = dataStreamStatus;
        this.indexTemplate = indexTemplate;
        this.ilmPolicyName = ilmPolicyName;
    }

    public String getName() {
        return this.name;
    }

    public String getTimeStampField() {
        return this.timeStampField;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public long getGeneration() {
        return this.generation;
    }

    public ClusterHealthStatus getDataStreamStatus() {
        return this.dataStreamStatus;
    }

    public String getIndexTemplate() {
        return this.indexTemplate;
    }

    public String getIlmPolicyName() {
        return this.ilmPolicyName;
    }

    public static DataStream fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStream that = (DataStream)o;
        return this.generation == that.generation && this.name.equals(that.name) && this.timeStampField.equals(that.timeStampField) && this.indices.equals(that.indices) && this.dataStreamStatus == that.dataStreamStatus && Objects.equals(this.indexTemplate, that.indexTemplate) && Objects.equals(this.ilmPolicyName, that.ilmPolicyName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timeStampField, this.indices, this.generation, this.dataStreamStatus, this.indexTemplate, this.ilmPolicyName);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), TIMESTAMP_FIELD_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), INDICES_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), GENERATION_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), STATUS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEX_TEMPLATE_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ILM_POLICY_FIELD);
    }
}

