/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.easysearch.client.Validatable;
import org.easysearch.client.ValidationException;
import org.easysearch.client.security.user.User;
import org.easysearch.common.CharArrays;
import org.easysearch.common.Nullable;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

public final class PutUserRequest
implements Validatable,
ToXContentObject {
    private final User user;
    @Nullable
    private final char[] password;

    public static PutUserRequest withPassword(User user, char[] password) {
        return new PutUserRequest(user, password);
    }

    public static PutUserRequest updateUser(User user) {
        return new PutUserRequest(user, null);
    }

    private PutUserRequest(User user, @Nullable char[] password) {
        this.user = Objects.requireNonNull(user, "user is required, cannot be null");
        this.password = password;
    }

    public User getUser() {
        return this.user;
    }

    @Nullable
    public char[] getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutUserRequest that = (PutUserRequest)o;
        return Objects.equals(this.user, that.user) && Arrays.equals(this.password, that.password);
    }

    public int hashCode() {
        int result = Objects.hash(this.user);
        result = 31 * result + Arrays.hashCode(this.password);
        return result;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.user.getAttributes() != null && this.user.getAttributes().keySet().stream().anyMatch(s2 -> s2.startsWith("_"))) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("user metadata keys may not start with [_]");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.password != null) {
            this.charField(builder, "password", this.password);
        }
        builder.field("roles", this.user.getRoles());
        builder.field("external_roles", this.user.getExternal_roles());
        if (this.user.getHash() != null) {
            builder.field("hash", this.user.getHash());
        }
        builder.field("attributes", this.user.getAttributes());
        return builder.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void charField(XContentBuilder builder, String fieldName, char[] chars) throws IOException {
        byte[] charBytes = CharArrays.toUtf8Bytes(chars);
        try {
            builder.field(fieldName).utf8Value(charBytes, 0, charBytes.length);
        }
        finally {
            Arrays.fill(charBytes, (byte)0);
        }
    }
}

