/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security.user.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.easysearch.client.security.user.RoleMapping;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentParserUtils;

public class RoleMappingJsonParser {
    public static Set<RoleMapping> parseRoleMappings(XContentParser jsonParser) throws IOException, IllegalArgumentException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, jsonParser.nextToken(), jsonParser);
        HashSet<RoleMapping> roleMappings = new HashSet<RoleMapping>();
        while ((token = jsonParser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, jsonParser);
            String name = jsonParser.currentName();
            jsonParser.nextToken();
            List<String> external_roles = new ArrayList<String>();
            List<String> and_external_roles = new ArrayList<String>();
            List<String> hosts = new ArrayList<String>();
            List<String> users = new ArrayList<String>();
            boolean reserved = false;
            boolean hidden = false;
            String description = null;
            while (jsonParser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = jsonParser.currentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "external_roles": {
                        external_roles = RoleMappingJsonParser.parseStringArray(jsonParser);
                        break;
                    }
                    case "and_external_roles": {
                        and_external_roles = RoleMappingJsonParser.parseStringArray(jsonParser);
                        break;
                    }
                    case "hosts": {
                        hosts = RoleMappingJsonParser.parseStringArray(jsonParser);
                        break;
                    }
                    case "users": {
                        users = RoleMappingJsonParser.parseStringArray(jsonParser);
                        break;
                    }
                    case "reserved": {
                        reserved = jsonParser.booleanValue();
                        break;
                    }
                    case "hidden": {
                        hidden = jsonParser.booleanValue();
                        break;
                    }
                    case "description": {
                        description = jsonParser.text();
                    }
                }
            }
            RoleMapping roleMapping = new RoleMapping(name, external_roles, and_external_roles, description, hosts, users, reserved, hidden);
            roleMappings.add(roleMapping);
        }
        return roleMappings;
    }

    private static List<String> parseStringArray(XContentParser jsonParser) throws IOException {
        ArrayList<String> stringList = new ArrayList<String>();
        while (jsonParser.nextToken() != XContentParser.Token.END_ARRAY) {
            stringList.add(jsonParser.text());
        }
        return stringList;
    }
}

