/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.watcher;

import org.easysearch.client.Validatable;
import org.easysearch.client.ValidationException;
import org.easysearch.client.watcher.PutWatchRequest;

public final class GetWatchRequest
implements Validatable {
    private final String id;

    public GetWatchRequest(String watchId) {
        this.validateId(watchId);
        this.id = watchId;
    }

    private void validateId(String id) {
        ValidationException exception = new ValidationException();
        if (id == null) {
            exception.addValidationError("watch id is missing");
        } else if (!PutWatchRequest.isValidId(id)) {
            exception.addValidationError("watch id contains whitespace");
        }
        if (!exception.validationErrors().isEmpty()) {
            throw exception;
        }
    }

    public String getId() {
        return this.id;
    }
}

