/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.io.stream;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.easysearch.EasysearchException;
import org.easysearch.Version;
import org.easysearch.common.CharArrays;
import org.easysearch.common.Nullable;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.collect.ImmutableOpenMap;
import org.easysearch.common.geo.GeoPoint;
import org.easysearch.common.io.stream.NamedWriteable;
import org.easysearch.common.io.stream.NotSerializableExceptionWrapper;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.settings.SecureString;
import org.easysearch.common.text.Text;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.common.util.concurrent.EsRejectedExecutionException;
import org.easysearch.script.JodaCompatibleZonedDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public abstract class StreamOutput
extends OutputStream {
    private static final int MAX_NESTED_EXCEPTION_LEVEL = 100;
    private Version version = Version.CURRENT;
    private Set<String> features = Collections.emptySet();
    private static final ThreadLocal<byte[]> scratch = ThreadLocal.withInitial(() -> new byte[1024]);
    private final BytesRefBuilder spare = new BytesRefBuilder();
    private static byte ZERO = 0;
    private static byte ONE = 1;
    private static byte TWO = (byte)2;
    private static final Map<Class<?>, Writeable.Writer> WRITERS;

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean hasFeature(String feature) {
        return this.features.contains(feature);
    }

    public void setFeatures(Set<String> features) {
        assert (this.features.isEmpty()) : this.features;
        this.features = Collections.unmodifiableSet(new HashSet<String>(features));
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public long position() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void seek(long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int length) throws IOException {
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeByteArray(byte[] b) throws IOException {
        this.writeVInt(b.length);
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytesReference(@Nullable BytesReference bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length());
        bytes.writeTo(this);
    }

    public void writeOptionalBytesReference(@Nullable BytesReference bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length() + 1);
        bytes.writeTo(this);
    }

    public void writeBytesRef(BytesRef bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length);
        this.write(bytes.bytes, bytes.offset, bytes.length);
    }

    public final void writeShort(short v) throws IOException {
        byte[] buffer = scratch.get();
        buffer[0] = (byte)(v >> 8);
        buffer[1] = (byte)v;
        this.writeBytes(buffer, 0, 2);
    }

    public void writeInt(int i) throws IOException {
        byte[] buffer = scratch.get();
        buffer[0] = (byte)(i >> 24);
        buffer[1] = (byte)(i >> 16);
        buffer[2] = (byte)(i >> 8);
        buffer[3] = (byte)i;
        this.writeBytes(buffer, 0, 4);
    }

    public void writeVInt(int i) throws IOException {
        if (Integer.numberOfLeadingZeros(i) >= 25) {
            this.writeByte((byte)i);
            return;
        }
        byte[] buffer = scratch.get();
        int index = 0;
        do {
            buffer[index++] = (byte)(i & 0x7F | 0x80);
        } while (((i >>>= 7) & 0xFFFFFF80) != 0);
        buffer[index++] = (byte)i;
        this.writeBytes(buffer, 0, index);
    }

    public void writeLong(long i) throws IOException {
        byte[] buffer = scratch.get();
        buffer[0] = (byte)(i >> 56);
        buffer[1] = (byte)(i >> 48);
        buffer[2] = (byte)(i >> 40);
        buffer[3] = (byte)(i >> 32);
        buffer[4] = (byte)(i >> 24);
        buffer[5] = (byte)(i >> 16);
        buffer[6] = (byte)(i >> 8);
        buffer[7] = (byte)i;
        this.writeBytes(buffer, 0, 8);
    }

    public void writeVLong(long i) throws IOException {
        if (i < 0L) {
            throw new IllegalStateException("Negative longs unsupported, use writeLong or writeZLong for negative numbers [" + i + "]");
        }
        this.writeVLongNoCheck(i);
    }

    public void writeOptionalVLong(@Nullable Long l) throws IOException {
        if (l == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeVLong(l);
        }
    }

    void writeVLongNoCheck(long i) throws IOException {
        byte[] buffer = scratch.get();
        int index = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer[index++] = (byte)(i & 0x7FL | 0x80L);
            i >>>= 7;
        }
        buffer[index++] = (byte)i;
        this.writeBytes(buffer, 0, index);
    }

    public void writeZLong(long i) throws IOException {
        byte[] buffer = scratch.get();
        int index = 0;
        long value = BitUtil.zigZagEncode((long)i);
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer[index++] = (byte)(value & 0x7FL | 0x80L);
            value >>>= 7;
        }
        buffer[index++] = (byte)(value & 0x7FL);
        this.writeBytes(buffer, 0, index);
    }

    public void writeOptionalLong(@Nullable Long l) throws IOException {
        if (l == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeLong(l);
        }
    }

    public void writeOptionalString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeString(str);
        }
    }

    public void writeOptionalSecureString(@Nullable SecureString secureStr) throws IOException {
        if (secureStr == null) {
            this.writeOptionalBytesReference(null);
        } else {
            byte[] secureStrBytes = CharArrays.toUtf8Bytes(secureStr.getChars());
            try {
                this.writeOptionalBytesReference(new BytesArray(secureStrBytes));
            }
            finally {
                Arrays.fill(secureStrBytes, (byte)0);
            }
        }
    }

    public void writeOptionalInt(@Nullable Integer integer) throws IOException {
        if (integer == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeInt(integer);
        }
    }

    public void writeOptionalVInt(@Nullable Integer integer) throws IOException {
        if (integer == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeVInt(integer);
        }
    }

    public void writeOptionalFloat(@Nullable Float floatValue) throws IOException {
        if (floatValue == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeFloat(floatValue.floatValue());
        }
    }

    public void writeOptionalText(@Nullable Text text) throws IOException {
        if (text == null) {
            this.writeInt(-1);
        } else {
            this.writeText(text);
        }
    }

    public void writeText(Text text) throws IOException {
        if (!text.hasBytes()) {
            String string = text.string();
            this.spare.copyChars((CharSequence)string);
            this.writeInt(this.spare.length());
            this.write(this.spare.bytes(), 0, this.spare.length());
        } else {
            BytesReference bytes = text.bytes();
            this.writeInt(bytes.length());
            bytes.writeTo(this);
        }
    }

    public void writeString(String str) throws IOException {
        int charCount = str.length();
        byte[] buffer = scratch.get();
        int offset = 0;
        this.writeVInt(charCount);
        for (int i = 0; i < charCount; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                buffer[offset++] = (byte)c;
            } else if (c > '\u07ff') {
                buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
                buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            if (offset <= buffer.length - 3) continue;
            this.writeBytes(buffer, offset);
            offset = 0;
        }
        this.writeBytes(buffer, offset);
    }

    public void writeSecureString(SecureString secureStr) throws IOException {
        byte[] secureStrBytes = CharArrays.toUtf8Bytes(secureStr.getChars());
        try {
            this.writeBytesReference(new BytesArray(secureStrBytes));
        }
        finally {
            Arrays.fill(secureStrBytes, (byte)0);
        }
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeOptionalDouble(@Nullable Double v) throws IOException {
        if (v == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeDouble(v);
        }
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeByte(b ? ONE : ZERO);
    }

    public void writeOptionalBoolean(@Nullable Boolean b) throws IOException {
        if (b == null) {
            this.writeByte(TWO);
        } else {
            this.writeBoolean(b);
        }
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void reset() throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public void writeStringArray(String[] array) throws IOException {
        this.writeVInt(array.length);
        for (String s2 : array) {
            this.writeString(s2);
        }
    }

    public void writeStringArrayNullable(@Nullable String[] array) throws IOException {
        if (array == null) {
            this.writeVInt(0);
        } else {
            this.writeVInt(array.length);
            for (String s2 : array) {
                this.writeString(s2);
            }
        }
    }

    public void writeOptionalStringArray(@Nullable String[] array) throws IOException {
        if (array == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeStringArray(array);
        }
    }

    public void writeMap(@Nullable Map<String, Object> map) throws IOException {
        this.writeGenericValue(map);
    }

    public void writeMapWithConsistentOrder(@Nullable Map<String, ? extends Object> map) throws IOException {
        if (map == null) {
            this.writeByte((byte)-1);
            return;
        }
        assert (!(map instanceof LinkedHashMap));
        this.writeByte((byte)10);
        this.writeVInt(map.size());
        Iterator iterator = map.entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            this.writeString((String)next.getKey());
            this.writeGenericValue(next.getValue());
        }
    }

    public final <K, V> void writeMapOfLists(Map<K, List<V>> map, Writeable.Writer<K> keyWriter, Writeable.Writer<V> valueWriter) throws IOException {
        this.writeMap(map, keyWriter, (StreamOutput stream, V list) -> {
            this.writeVInt(list.size());
            for (Object value : list) {
                valueWriter.write(this, value);
            }
        });
    }

    public final <K, V> void writeMap(Map<K, V> map, Writeable.Writer<K> keyWriter, Writeable.Writer<V> valueWriter) throws IOException {
        this.writeVInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyWriter.write(this, entry.getKey());
            valueWriter.write(this, entry.getValue());
        }
    }

    public final <K, V> void writeMap(ImmutableOpenMap<K, V> map, Writeable.Writer<K> keyWriter, Writeable.Writer<V> valueWriter) throws IOException {
        this.writeVInt(map.size());
        for (ObjectObjectCursor<K, V> objectObjectCursor : map) {
            keyWriter.write(this, objectObjectCursor.key);
            valueWriter.write(this, objectObjectCursor.value);
        }
    }

    public final <K extends Writeable, V extends Writeable> void writeMap(ImmutableOpenMap<K, V> map) throws IOException {
        this.writeMap(map, (StreamOutput o, K k) -> k.writeTo(o), (StreamOutput o, V v) -> v.writeTo(o));
    }

    public final void writeInstant(Instant instant) throws IOException {
        this.writeLong(instant.getEpochSecond());
        this.writeInt(instant.getNano());
    }

    public final void writeOptionalInstant(@Nullable Instant instant) throws IOException {
        if (instant == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeInstant(instant);
        }
    }

    private static Class<?> getGenericType(Object value) {
        if (value instanceof List) {
            return List.class;
        }
        if (value instanceof Object[]) {
            return Object[].class;
        }
        if (value instanceof Map) {
            return Map.class;
        }
        if (value instanceof Set) {
            return Set.class;
        }
        if (value instanceof ReadableInstant) {
            return ReadableInstant.class;
        }
        if (value instanceof BytesReference) {
            return BytesReference.class;
        }
        return value.getClass();
    }

    public void writeGenericValue(@Nullable Object value) throws IOException {
        if (value == null) {
            this.writeByte((byte)-1);
            return;
        }
        Class<?> type = StreamOutput.getGenericType(value);
        Writeable.Writer writer = WRITERS.get(type);
        if (writer == null) {
            throw new IllegalArgumentException("can not write type [" + type + "]");
        }
        writer.write(this, value);
    }

    public static void checkWriteable(@Nullable Object value) throws IllegalArgumentException {
        if (value == null) {
            return;
        }
        Class<?> type = StreamOutput.getGenericType(value);
        if (type == List.class) {
            List list = (List)value;
            for (Object v : list) {
                StreamOutput.checkWriteable(v);
            }
        } else if (type == Object[].class) {
            Object[] array;
            for (Object v : array = (Object[])value) {
                StreamOutput.checkWriteable(v);
            }
        } else if (type == Map.class) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                StreamOutput.checkWriteable(entry.getKey());
                StreamOutput.checkWriteable(entry.getValue());
            }
        } else if (type == Set.class) {
            Set set = (Set)value;
            for (Object v : set) {
                StreamOutput.checkWriteable(v);
            }
        } else if (!WRITERS.containsKey(type)) {
            throw new IllegalArgumentException("Cannot write type [" + type.getCanonicalName() + "] to stream");
        }
    }

    public void writeIntArray(int[] values) throws IOException {
        this.writeVInt(values.length);
        for (int value : values) {
            this.writeInt(value);
        }
    }

    public void writeVIntArray(int[] values) throws IOException {
        this.writeVInt(values.length);
        for (int value : values) {
            this.writeVInt(value);
        }
    }

    public void writeLongArray(long[] values) throws IOException {
        this.writeVInt(values.length);
        for (long value : values) {
            this.writeLong(value);
        }
    }

    public void writeVLongArray(long[] values) throws IOException {
        this.writeVInt(values.length);
        for (long value : values) {
            this.writeVLong(value);
        }
    }

    public void writeFloatArray(float[] values) throws IOException {
        this.writeVInt(values.length);
        for (float value : values) {
            this.writeFloat(value);
        }
    }

    public void writeDoubleArray(double[] values) throws IOException {
        this.writeVInt(values.length);
        for (double value : values) {
            this.writeDouble(value);
        }
    }

    public <T> void writeArray(Writeable.Writer<T> writer, T[] array) throws IOException {
        this.writeVInt(array.length);
        for (T value : array) {
            writer.write(this, value);
        }
    }

    public <T> void writeOptionalArray(Writeable.Writer<T> writer, @Nullable T[] array) throws IOException {
        if (array == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeArray(writer, array);
        }
    }

    public <T extends Writeable> void writeArray(T[] array) throws IOException {
        this.writeArray((out, value) -> value.writeTo(out), array);
    }

    public <T extends Writeable> void writeOptionalArray(@Nullable T[] array) throws IOException {
        this.writeOptionalArray((out, value) -> value.writeTo(out), array);
    }

    public void writeOptionalWriteable(@Nullable Writeable writeable) throws IOException {
        if (writeable != null) {
            this.writeBoolean(true);
            writeable.writeTo(this);
        } else {
            this.writeBoolean(false);
        }
    }

    public void writeException(Throwable throwable) throws IOException {
        this.writeException(throwable, throwable, 0);
    }

    private void writeException(Throwable rootException, Throwable throwable, int nestedLevel) throws IOException {
        if (throwable == null) {
            this.writeBoolean(false);
        } else if (nestedLevel > 100) {
            assert (this.failOnTooManyNestedExceptions(rootException));
            this.writeException(new IllegalStateException("too many nested exceptions"));
        } else {
            this.writeBoolean(true);
            boolean writeCause = true;
            boolean writeMessage = true;
            if (throwable instanceof CorruptIndexException) {
                this.writeVInt(1);
                this.writeOptionalString(((CorruptIndexException)throwable).getOriginalMessage());
                this.writeOptionalString(((CorruptIndexException)throwable).getResourceDescription());
                writeMessage = false;
            } else if (throwable instanceof IndexFormatTooNewException) {
                this.writeVInt(2);
                this.writeOptionalString(((IndexFormatTooNewException)throwable).getResourceDescription());
                this.writeInt(((IndexFormatTooNewException)throwable).getVersion());
                this.writeInt(((IndexFormatTooNewException)throwable).getMinVersion());
                this.writeInt(((IndexFormatTooNewException)throwable).getMaxVersion());
                writeMessage = false;
                writeCause = false;
            } else if (throwable instanceof IndexFormatTooOldException) {
                this.writeVInt(3);
                IndexFormatTooOldException t2 = (IndexFormatTooOldException)throwable;
                this.writeOptionalString(t2.getResourceDescription());
                if (t2.getVersion() == null) {
                    this.writeBoolean(false);
                    this.writeOptionalString(t2.getReason());
                } else {
                    this.writeBoolean(true);
                    this.writeInt(t2.getVersion());
                    this.writeInt(t2.getMinVersion());
                    this.writeInt(t2.getMaxVersion());
                }
                writeMessage = false;
                writeCause = false;
            } else if (throwable instanceof NullPointerException) {
                this.writeVInt(4);
                writeCause = false;
            } else if (throwable instanceof NumberFormatException) {
                this.writeVInt(5);
                writeCause = false;
            } else if (throwable instanceof IllegalArgumentException) {
                this.writeVInt(6);
            } else if (throwable instanceof AlreadyClosedException) {
                this.writeVInt(7);
            } else if (throwable instanceof EOFException) {
                this.writeVInt(8);
                writeCause = false;
            } else if (throwable instanceof SecurityException) {
                this.writeVInt(9);
            } else if (throwable instanceof StringIndexOutOfBoundsException) {
                this.writeVInt(10);
                writeCause = false;
            } else if (throwable instanceof ArrayIndexOutOfBoundsException) {
                this.writeVInt(11);
                writeCause = false;
            } else if (throwable instanceof FileNotFoundException) {
                this.writeVInt(12);
                writeCause = false;
            } else if (throwable instanceof FileSystemException) {
                this.writeVInt(13);
                if (throwable instanceof NoSuchFileException) {
                    this.writeVInt(0);
                } else if (throwable instanceof NotDirectoryException) {
                    this.writeVInt(1);
                } else if (throwable instanceof DirectoryNotEmptyException) {
                    this.writeVInt(2);
                } else if (throwable instanceof AtomicMoveNotSupportedException) {
                    this.writeVInt(3);
                } else if (throwable instanceof FileAlreadyExistsException) {
                    this.writeVInt(4);
                } else if (throwable instanceof AccessDeniedException) {
                    this.writeVInt(5);
                } else if (throwable instanceof FileSystemLoopException) {
                    this.writeVInt(6);
                } else {
                    this.writeVInt(7);
                }
                this.writeOptionalString(((FileSystemException)throwable).getFile());
                this.writeOptionalString(((FileSystemException)throwable).getOtherFile());
                this.writeOptionalString(((FileSystemException)throwable).getReason());
                writeCause = false;
            } else if (throwable instanceof IllegalStateException) {
                this.writeVInt(14);
            } else if (throwable instanceof LockObtainFailedException) {
                this.writeVInt(15);
            } else if (throwable instanceof InterruptedException) {
                this.writeVInt(16);
                writeCause = false;
            } else if (throwable instanceof IOException) {
                this.writeVInt(17);
            } else if (throwable instanceof EsRejectedExecutionException) {
                this.writeVInt(18);
                this.writeBoolean(((EsRejectedExecutionException)throwable).isExecutorShutdown());
                writeCause = false;
            } else {
                EasysearchException ex = throwable instanceof EasysearchException && EasysearchException.isRegistered(throwable.getClass(), this.version) ? (EasysearchException)throwable : new NotSerializableExceptionWrapper(throwable);
                this.writeVInt(0);
                this.writeVInt(EasysearchException.getId(ex.getClass()));
                ex.writeTo(this);
                return;
            }
            if (writeMessage) {
                this.writeOptionalString(throwable.getMessage());
            }
            if (writeCause) {
                this.writeException(rootException, throwable.getCause(), nestedLevel + 1);
            }
            EasysearchException.writeStackTraces(throwable, this, (o, t) -> o.writeException(rootException, (Throwable)t, nestedLevel + 1));
        }
    }

    boolean failOnTooManyNestedExceptions(Throwable throwable) {
        throw new AssertionError("too many nested exceptions", throwable);
    }

    public void writeNamedWriteable(NamedWriteable namedWriteable) throws IOException {
        this.writeString(namedWriteable.getWriteableName());
        namedWriteable.writeTo(this);
    }

    public void writeOptionalNamedWriteable(@Nullable NamedWriteable namedWriteable) throws IOException {
        if (namedWriteable == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeNamedWriteable(namedWriteable);
        }
    }

    public void writeGeoPoint(GeoPoint geoPoint) throws IOException {
        this.writeDouble(geoPoint.lat());
        this.writeDouble(geoPoint.lon());
    }

    public void writeTimeZone(DateTimeZone timeZone) throws IOException {
        this.writeString(timeZone.getID());
    }

    public void writeZoneId(ZoneId timeZone) throws IOException {
        this.writeString(timeZone.getId());
    }

    public void writeOptionalTimeZone(@Nullable DateTimeZone timeZone) throws IOException {
        if (timeZone == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeTimeZone(timeZone);
        }
    }

    public void writeOptionalZoneId(@Nullable ZoneId timeZone) throws IOException {
        if (timeZone == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeZoneId(timeZone);
        }
    }

    public void writeCollection(Collection<? extends Writeable> collection) throws IOException {
        this.writeCollection(collection, (o, v) -> v.writeTo(o));
    }

    public void writeList(List<? extends Writeable> list) throws IOException {
        this.writeCollection(list);
    }

    public <T> void writeCollection(Collection<T> collection, Writeable.Writer<T> writer) throws IOException {
        this.writeVInt(collection.size());
        for (T val : collection) {
            writer.write(this, val);
        }
    }

    public void writeStringCollection(Collection<String> collection) throws IOException {
        this.writeCollection(collection, StreamOutput::writeString);
    }

    public void writeOptionalStringCollection(Collection<String> collection) throws IOException {
        if (collection != null) {
            this.writeBoolean(true);
            this.writeCollection(collection, StreamOutput::writeString);
        } else {
            this.writeBoolean(false);
        }
    }

    public void writeNamedWriteableList(List<? extends NamedWriteable> list) throws IOException {
        this.writeVInt(list.size());
        for (NamedWriteable namedWriteable : list) {
            this.writeNamedWriteable(namedWriteable);
        }
    }

    public <E extends Enum<E>> void writeEnum(E enumValue) throws IOException {
        this.writeVInt(enumValue.ordinal());
    }

    public <E extends Enum<E>> void writeEnumSet(EnumSet<E> enumSet) throws IOException {
        this.writeVInt(enumSet.size());
        for (Enum e : enumSet) {
            this.writeEnum(e);
        }
    }

    public void writeTimeValue(TimeValue timeValue) throws IOException {
        this.writeZLong(timeValue.duration());
        this.writeByte((byte)timeValue.timeUnit().ordinal());
    }

    public void writeOptionalTimeValue(@Nullable TimeValue timeValue) throws IOException {
        if (timeValue == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeTimeValue(timeValue);
        }
    }

    static {
        HashMap<Class, Writeable.Writer<Object>> writers = new HashMap<Class, Writeable.Writer<Object>>();
        writers.put(String.class, (o, v) -> {
            o.writeByte((byte)0);
            o.writeString((String)v);
        });
        writers.put(Integer.class, (o, v) -> {
            o.writeByte((byte)1);
            o.writeInt((Integer)v);
        });
        writers.put(Long.class, (o, v) -> {
            o.writeByte((byte)2);
            o.writeLong((Long)v);
        });
        writers.put(Float.class, (o, v) -> {
            o.writeByte((byte)3);
            o.writeFloat(((Float)v).floatValue());
        });
        writers.put(Double.class, (o, v) -> {
            o.writeByte((byte)4);
            o.writeDouble((Double)v);
        });
        writers.put(Boolean.class, (o, v) -> {
            o.writeByte((byte)5);
            o.writeBoolean((Boolean)v);
        });
        writers.put(byte[].class, (o, v) -> {
            o.writeByte((byte)6);
            byte[] bytes = (byte[])v;
            o.writeVInt(bytes.length);
            o.writeBytes(bytes);
        });
        writers.put(List.class, (o, v) -> {
            o.writeByte((byte)7);
            List list = (List)v;
            o.writeVInt(list.size());
            for (Object item : list) {
                o.writeGenericValue(item);
            }
        });
        writers.put(Object[].class, (o, v) -> {
            o.writeByte((byte)8);
            Object[] list = (Object[])v;
            o.writeVInt(list.length);
            for (Object item : list) {
                o.writeGenericValue(item);
            }
        });
        writers.put(Map.class, (o, v) -> {
            if (v instanceof LinkedHashMap) {
                o.writeByte((byte)9);
            } else {
                o.writeByte((byte)10);
            }
            Map map = (Map)v;
            o.writeVInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                o.writeString((String)entry.getKey());
                o.writeGenericValue(entry.getValue());
            }
        });
        writers.put(Byte.class, (o, v) -> {
            o.writeByte((byte)11);
            o.writeByte((Byte)v);
        });
        writers.put(Date.class, (o, v) -> {
            o.writeByte((byte)12);
            o.writeLong(((Date)v).getTime());
        });
        writers.put(ReadableInstant.class, (o, v) -> {
            o.writeByte((byte)13);
            ReadableInstant instant = (ReadableInstant)v;
            o.writeString(instant.getZone().getID());
            o.writeLong(instant.getMillis());
        });
        writers.put(BytesReference.class, (o, v) -> {
            o.writeByte((byte)14);
            o.writeBytesReference((BytesReference)v);
        });
        writers.put(Text.class, (o, v) -> {
            o.writeByte((byte)15);
            o.writeText((Text)v);
        });
        writers.put(Short.class, (o, v) -> {
            o.writeByte((byte)16);
            o.writeShort((Short)v);
        });
        writers.put(int[].class, (o, v) -> {
            o.writeByte((byte)17);
            o.writeIntArray((int[])v);
        });
        writers.put(long[].class, (o, v) -> {
            o.writeByte((byte)18);
            o.writeLongArray((long[])v);
        });
        writers.put(float[].class, (o, v) -> {
            o.writeByte((byte)19);
            o.writeFloatArray((float[])v);
        });
        writers.put(double[].class, (o, v) -> {
            o.writeByte((byte)20);
            o.writeDoubleArray((double[])v);
        });
        writers.put(BytesRef.class, (o, v) -> {
            o.writeByte((byte)21);
            o.writeBytesRef((BytesRef)v);
        });
        writers.put(GeoPoint.class, (o, v) -> {
            o.writeByte((byte)22);
            o.writeGeoPoint((GeoPoint)v);
        });
        writers.put(ZonedDateTime.class, (o, v) -> {
            o.writeByte((byte)23);
            ZonedDateTime zonedDateTime = (ZonedDateTime)v;
            o.writeString(zonedDateTime.getZone().getId());
            o.writeLong(zonedDateTime.toInstant().toEpochMilli());
        });
        writers.put(JodaCompatibleZonedDateTime.class, (o, v) -> {
            o.writeByte((byte)13);
            JodaCompatibleZonedDateTime zonedDateTime = (JodaCompatibleZonedDateTime)v;
            String zoneId = zonedDateTime.getZonedDateTime().getZone().getId();
            o.writeString(zoneId.equals("Z") ? DateTimeZone.UTC.getID() : zoneId);
            o.writeLong(zonedDateTime.toInstant().toEpochMilli());
        });
        writers.put(Set.class, (o, v) -> {
            if (v instanceof LinkedHashSet) {
                o.writeByte((byte)24);
            } else {
                o.writeByte((byte)25);
            }
            o.writeCollection((Set)v, StreamOutput::writeGenericValue);
        });
        writers.put(BigInteger.class, (o, v) -> {
            o.writeByte((byte)26);
            o.writeString(v.toString());
        });
        WRITERS = Collections.unmodifiableMap(writers);
    }
}

