/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.settings;

import joptsimple.OptionSet;
import org.easysearch.cli.Terminal;
import org.easysearch.cli.UserException;
import org.easysearch.common.settings.BaseKeyStoreCommand;
import org.easysearch.common.settings.KeyStoreWrapper;
import org.easysearch.common.settings.SecureString;
import org.easysearch.env.Environment;

class ChangeKeyStorePasswordCommand
extends BaseKeyStoreCommand {
    ChangeKeyStorePasswordCommand() {
        super("Changes the password of a keystore", true);
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        try (SecureString newPassword = ChangeKeyStorePasswordCommand.readPassword(terminal, true);){
            KeyStoreWrapper keyStore = this.getKeyStore();
            keyStore.save(env.configFile(), newPassword.getChars());
            terminal.println("Easysearch keystore password changed successfully.");
        }
        catch (SecurityException e) {
            throw new UserException(65, e.getMessage());
        }
    }
}

