/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.cache.bitset;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitSet;
import org.easysearch.ExceptionsHelper;
import org.easysearch.common.cache.Cache;
import org.easysearch.common.cache.CacheBuilder;
import org.easysearch.common.cache.CacheLoader;
import org.easysearch.common.cache.RemovalListener;
import org.easysearch.common.cache.RemovalNotification;
import org.easysearch.common.lucene.index.EasysearchDirectoryReader;
import org.easysearch.common.lucene.search.Queries;
import org.easysearch.common.settings.Setting;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.index.AbstractIndexComponent;
import org.easysearch.index.IndexSettings;
import org.easysearch.index.IndexWarmer;
import org.easysearch.index.mapper.DocumentMapper;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.ObjectMapper;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.index.shard.ShardId;
import org.easysearch.index.shard.ShardUtils;
import org.easysearch.threadpool.ThreadPool;

public final class BitsetFilterCache
extends AbstractIndexComponent
implements IndexReader.ClosedListener,
RemovalListener<IndexReader.CacheKey, Cache<Query, Value>>,
Closeable {
    public static final Setting<Boolean> INDEX_LOAD_RANDOM_ACCESS_FILTERS_EAGERLY_SETTING = Setting.boolSetting("index.load_fixed_bitset_filters_eagerly", true, Setting.Property.IndexScope);
    private final boolean loadRandomAccessFiltersEagerly;
    private final Cache<IndexReader.CacheKey, Cache<Query, Value>> loadedFilters;
    private final Listener listener;

    public BitsetFilterCache(IndexSettings indexSettings, Listener listener) {
        super(indexSettings);
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.loadRandomAccessFiltersEagerly = this.indexSettings.getValue(INDEX_LOAD_RANDOM_ACCESS_FILTERS_EAGERLY_SETTING);
        this.loadedFilters = CacheBuilder.builder().removalListener(this).build();
        this.listener = listener;
    }

    public static BitSet bitsetFromQuery(Query query, LeafReaderContext context) throws IOException {
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
        IndexSearcher searcher = new IndexSearcher(topLevelContext);
        searcher.setQueryCache(null);
        Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer s2 = weight.scorer(context);
        if (s2 == null) {
            return null;
        }
        return BitSet.of((DocIdSetIterator)s2.iterator(), (int)context.reader().maxDoc());
    }

    public IndexWarmer.Listener createListener(ThreadPool threadPool) {
        return new BitSetProducerWarmer(threadPool);
    }

    public BitSetProducer getBitSetProducer(Query query) {
        return new QueryWrapperBitSetProducer(query);
    }

    public void onClose(IndexReader.CacheKey ownerCoreCacheKey) {
        this.loadedFilters.invalidate(ownerCoreCacheKey);
    }

    @Override
    public void close() {
        this.clear("close");
    }

    public void clear(String reason) {
        this.logger.debug("clearing all bitsets because [{}]", (Object)reason);
        this.loadedFilters.invalidateAll();
    }

    private BitSet getAndLoadIfNotPresent(Query query, LeafReaderContext context) throws ExecutionException {
        IndexReader.CacheHelper cacheHelper = context.reader().getCoreCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalArgumentException("Reader " + context.reader() + " does not support caching");
        }
        IndexReader.CacheKey coreCacheReader = cacheHelper.getKey();
        ShardId shardId = ShardUtils.extractShardId(context.reader());
        if (!this.indexSettings.getIndex().equals(shardId.getIndex())) {
            throw new IllegalStateException("Trying to load bit set for index " + shardId.getIndex() + " with cache of index " + this.indexSettings.getIndex());
        }
        Cache filterToFbs = this.loadedFilters.computeIfAbsent(coreCacheReader, key -> {
            cacheHelper.addClosedListener((IndexReader.ClosedListener)this);
            return CacheBuilder.builder().build();
        });
        return filterToFbs.computeIfAbsent(query, (CacheLoader<Query, Value>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getAndLoadIfNotPresent$1(org.apache.lucene.search.Query org.apache.lucene.index.LeafReaderContext org.easysearch.index.shard.ShardId org.apache.lucene.search.Query ), (Lorg/apache/lucene/search/Query;)Lorg/easysearch/index/cache/bitset/BitsetFilterCache$Value;)((BitsetFilterCache)this, (Query)query, (LeafReaderContext)context, (ShardId)shardId)).bitset;
    }

    @Override
    public void onRemoval(RemovalNotification<IndexReader.CacheKey, Cache<Query, Value>> notification) {
        if (notification.getKey() == null) {
            return;
        }
        Cache<Query, Value> valueCache = notification.getValue();
        if (valueCache == null) {
            return;
        }
        for (Value value : valueCache.values()) {
            this.listener.onRemoval(value.shardId, (Accountable)value.bitset);
        }
    }

    Cache<IndexReader.CacheKey, Cache<Query, Value>> getLoadedFilters() {
        return this.loadedFilters;
    }

    private /* synthetic */ Value lambda$getAndLoadIfNotPresent$1(Query query, LeafReaderContext context, ShardId shardId, Query key) throws Exception {
        BitSet bitSet = BitsetFilterCache.bitsetFromQuery(query, context);
        Value value = new Value(bitSet, shardId);
        this.listener.onCache(shardId, (Accountable)value.bitset);
        return value;
    }

    public static interface Listener {
        public void onCache(ShardId var1, Accountable var2);

        public void onRemoval(ShardId var1, Accountable var2);
    }

    final class BitSetProducerWarmer
    implements IndexWarmer.Listener {
        private final Executor executor;

        BitSetProducerWarmer(ThreadPool threadPool) {
            this.executor = threadPool.executor("warmer");
        }

        @Override
        public IndexWarmer.TerminationHandle warmReader(IndexShard indexShard, EasysearchDirectoryReader reader) {
            if (!BitsetFilterCache.this.indexSettings.getIndex().equals(indexShard.indexSettings().getIndex())) {
                return IndexWarmer.TerminationHandle.NO_WAIT;
            }
            if (!BitsetFilterCache.this.loadRandomAccessFiltersEagerly) {
                return IndexWarmer.TerminationHandle.NO_WAIT;
            }
            boolean hasNested = false;
            HashSet<Query> warmUp = new HashSet<Query>();
            MapperService mapperService = indexShard.mapperService();
            DocumentMapper docMapper = mapperService.documentMapper();
            if (docMapper != null && docMapper.hasNestedObjects()) {
                hasNested = true;
                for (ObjectMapper objectMapper : docMapper.objectMappers().values()) {
                    ObjectMapper parentObjectMapper;
                    if (!objectMapper.nested().isNested() || (parentObjectMapper = objectMapper.getParentObjectMapper(mapperService)) == null || !parentObjectMapper.nested().isNested()) continue;
                    warmUp.add(parentObjectMapper.nestedTypeFilter());
                }
            }
            if (hasNested) {
                warmUp.add(Queries.newNonNestedFilter(BitsetFilterCache.this.indexSettings.getIndexVersionCreated()));
            }
            CountDownLatch latch = new CountDownLatch(reader.leaves().size() * warmUp.size());
            for (LeafReaderContext ctx : reader.leaves()) {
                for (Query filterToWarm : warmUp) {
                    this.executor.execute(() -> {
                        try {
                            long start = System.nanoTime();
                            BitsetFilterCache.this.getAndLoadIfNotPresent(filterToWarm, ctx);
                            if (indexShard.warmerService().logger().isTraceEnabled()) {
                                indexShard.warmerService().logger().trace("warmed bitset for [{}], took [{}]", (Object)filterToWarm, (Object)TimeValue.timeValueNanos(System.nanoTime() - start));
                            }
                        }
                        catch (Exception e) {
                            indexShard.warmerService().logger().warn(() -> new ParameterizedMessage("failed to load bitset for [{}]", (Object)filterToWarm), (Throwable)e);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
            }
            return () -> latch.await();
        }
    }

    final class QueryWrapperBitSetProducer
    implements BitSetProducer {
        final Query query;

        QueryWrapperBitSetProducer(Query query) {
            this.query = Objects.requireNonNull(query);
        }

        public BitSet getBitSet(LeafReaderContext context) throws IOException {
            try {
                return BitsetFilterCache.this.getAndLoadIfNotPresent(this.query, context);
            }
            catch (ExecutionException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
        }

        public String toString() {
            return "random_access(" + this.query + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof QueryWrapperBitSetProducer)) {
                return false;
            }
            return this.query.equals((Object)((QueryWrapperBitSetProducer)o).query);
        }

        public int hashCode() {
            return 31 * this.getClass().hashCode() + this.query.hashCode();
        }
    }

    public static final class Value {
        final BitSet bitset;
        final ShardId shardId;

        public Value(BitSet bitset, ShardId shardId) {
            this.bitset = bitset;
            this.shardId = shardId;
        }
    }
}

