/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.fielddata;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.Sorter;
import org.easysearch.index.fielddata.SortedNumericDoubleValues;

public abstract class SortingNumericDoubleValues
extends SortedNumericDoubleValues {
    private int count;
    private int valuesCursor = 0;
    protected double[] values = new double[1];
    private final Sorter sorter = new InPlaceMergeSorter(){

        protected void swap(int i, int j) {
            double tmp = SortingNumericDoubleValues.this.values[i];
            SortingNumericDoubleValues.this.values[i] = SortingNumericDoubleValues.this.values[j];
            SortingNumericDoubleValues.this.values[j] = tmp;
        }

        protected int compare(int i, int j) {
            return Double.compare(SortingNumericDoubleValues.this.values[i], SortingNumericDoubleValues.this.values[j]);
        }
    };

    protected SortingNumericDoubleValues() {
    }

    protected final void resize(int newSize) {
        this.count = newSize;
        this.values = ArrayUtil.grow((double[])this.values, (int)this.count);
        this.valuesCursor = 0;
    }

    protected final void sort() {
        this.sorter.sort(0, this.count);
    }

    @Override
    public final int docValueCount() {
        return this.count;
    }

    @Override
    public final double nextValue() {
        return this.values[this.valuesCursor++];
    }
}

