/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.easysearch.EasysearchParseException;
import org.easysearch.common.Explicit;
import org.easysearch.common.geo.GeoPoint;
import org.easysearch.common.geo.GeoUtils;
import org.easysearch.common.geo.ShapeRelation;
import org.easysearch.common.unit.DistanceUnit;
import org.easysearch.geometry.Geometry;
import org.easysearch.geometry.Point;
import org.easysearch.index.fielddata.IndexFieldData;
import org.easysearch.index.fielddata.plain.AbstractLatLonPointIndexFieldData;
import org.easysearch.index.mapper.AbstractGeometryFieldMapper;
import org.easysearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.easysearch.index.mapper.FieldMapper;
import org.easysearch.index.mapper.GeoShapeQueryable;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.ParseContext;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.index.query.VectorGeoPointShapeQueryProcessor;
import org.easysearch.search.aggregations.support.CoreValuesSourceType;
import org.easysearch.search.lookup.SearchLookup;

public class GeoPointFieldMapper
extends AbstractPointGeometryFieldMapper<List<ParsedGeoPoint>, List<? extends GeoPoint>> {
    public static final String CONTENT_TYPE = "geo_point";
    public static final FieldType FIELD_TYPE = new FieldType();

    public GeoPointFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, AbstractPointGeometryFieldMapper.ParsedPoint nullValue, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, ignoreMalformed, ignoreZValue, nullValue, copyTo);
    }

    @Override
    protected void addStoredFields(ParseContext context, List<? extends GeoPoint> points) {
        for (GeoPoint geoPoint : points) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), geoPoint.toString()));
        }
    }

    @Override
    protected void addMultiFields(ParseContext context, List<? extends GeoPoint> points) throws IOException {
        if (points.isEmpty()) {
            return;
        }
        StringBuilder s2 = new StringBuilder();
        if (points.size() > 1) {
            s2.append('[');
        }
        s2.append(points.get(0).geohash());
        for (int i = 1; i < points.size(); ++i) {
            s2.append(',');
            s2.append(points.get(i).geohash());
        }
        if (points.size() > 1) {
            s2.append(']');
        }
        this.multiFields.parse(this, context.createExternalValueContext(s2));
    }

    @Override
    protected void addDocValuesFields(String name, List<? extends GeoPoint> points, List<IndexableField> fields, ParseContext context) {
        for (GeoPoint geoPoint : points) {
            context.doc().add((IndexableField)new LatLonDocValuesField(this.fieldType().name(), geoPoint.lat(), geoPoint.lon()));
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public GeoPointFieldType fieldType() {
        return (GeoPointFieldType)this.mappedFieldType;
    }

    static {
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.freeze();
    }

    public static class GeoPointFieldType
    extends AbstractPointGeometryFieldMapper.AbstractPointGeometryFieldType<List<ParsedGeoPoint>, List<? extends GeoPoint>>
    implements GeoShapeQueryable {
        private final VectorGeoPointShapeQueryProcessor queryProcessor = new VectorGeoPointShapeQueryProcessor();

        private GeoPointFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, meta);
        }

        public GeoPointFieldType(String name) {
            this(name, true, false, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return GeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
            return this.queryProcessor.geoShapeQuery(shape, fieldName, relation, context);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new AbstractLatLonPointIndexFieldData.Builder(this.name(), CoreValuesSourceType.GEOPOINT);
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, float boost, QueryShardContext context) {
            GeoPoint originGeoPoint;
            if (origin instanceof GeoPoint) {
                originGeoPoint = (GeoPoint)origin;
            } else if (origin instanceof String) {
                originGeoPoint = GeoUtils.parseFromString((String)origin);
            } else {
                throw new IllegalArgumentException("Illegal type [" + origin.getClass() + "] for [origin]! Must be of type [geo_point] or [string] for geo_point fields!");
            }
            double pivotDouble = DistanceUnit.DEFAULT.parse(pivot, DistanceUnit.DEFAULT);
            return LatLonPoint.newDistanceFeatureQuery((String)this.name(), (float)boost, (double)originGeoPoint.lat(), (double)originGeoPoint.lon(), (double)pivotDouble);
        }
    }

    protected static class GeoPointIndexer
    implements AbstractGeometryFieldMapper.Indexer<List<ParsedGeoPoint>, List<? extends GeoPoint>> {
        protected final GeoPointFieldType fieldType;

        GeoPointIndexer(GeoPointFieldType fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public List<? extends GeoPoint> prepareForIndexing(List<ParsedGeoPoint> geoPoints) {
            if (geoPoints == null || geoPoints.isEmpty()) {
                return Collections.emptyList();
            }
            return geoPoints;
        }

        @Override
        public Class<List<? extends GeoPoint>> processedClass() {
            return List.class;
        }

        @Override
        public List<IndexableField> indexShape(ParseContext context, List<? extends GeoPoint> points) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>(points.size());
            for (GeoPoint geoPoint : points) {
                fields.add((IndexableField)new LatLonPoint(this.fieldType.name(), geoPoint.lat(), geoPoint.lon()));
            }
            return fields;
        }
    }

    protected static class ParsedGeoPoint
    extends GeoPoint
    implements AbstractPointGeometryFieldMapper.ParsedPoint {
        protected ParsedGeoPoint() {
        }

        @Override
        public void validate(String fieldName) {
            if (this.lat() > 90.0 || this.lat() < -90.0) {
                throw new IllegalArgumentException("illegal latitude value [" + this.lat() + "] for " + fieldName);
            }
            if (this.lon() > 180.0 || this.lon() < -180.0) {
                throw new IllegalArgumentException("illegal longitude value [" + this.lon() + "] for " + fieldName);
            }
        }

        @Override
        public void normalize(String name) {
            if (!this.isNormalizable(this.lat()) || !this.isNormalizable(this.lon())) {
                throw new EasysearchParseException("cannot normalize the point - not a number", new Object[0]);
            }
            GeoUtils.normalizePoint(this);
        }

        @Override
        public boolean isNormalizable(double coord) {
            return !Double.isNaN(coord) && !Double.isInfinite(coord);
        }

        @Override
        public void resetCoords(double x, double y) {
            this.reset(y, x);
        }

        @Override
        public Point asGeometry() {
            return new Point(this.lon(), this.lat());
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof GeoPoint)) {
                return false;
            }
            GeoPoint o = (GeoPoint)other;
            double oLat = o.lat();
            double oLon = o.lon();
            if (Double.compare(oLat, this.lat) != 0) {
                return false;
            }
            return Double.compare(oLon, this.lon) == 0;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class TypeParser
    extends AbstractPointGeometryFieldMapper.TypeParser<Builder> {
        @Override
        protected Builder newBuilder(String name, Map<String, Object> params) {
            return new Builder(name);
        }

        @Override
        protected ParsedGeoPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            ParsedGeoPoint point = new ParsedGeoPoint();
            GeoUtils.parseGeoPoint(nullValue, (GeoPoint)point, ignoreZValue);
            if (!ignoreMalformed) {
                if (point.lat() > 90.0 || point.lat() < -90.0) {
                    throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "]");
                }
                if (point.lon() > 180.0 || point.lon() < -180.0) {
                    throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "]");
                }
            } else {
                GeoUtils.normalizePoint(point);
            }
            return point;
        }
    }

    public static class Builder
    extends AbstractPointGeometryFieldMapper.Builder<Builder, GeoPointFieldType> {
        public Builder(String name) {
            super(name, FIELD_TYPE);
            this.hasDocValues = true;
            this.builder = this;
        }

        @Override
        public GeoPointFieldMapper build(Mapper.BuilderContext context, String simpleName, FieldType fieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, AbstractPointGeometryFieldMapper.ParsedPoint nullValue, FieldMapper.CopyTo copyTo) {
            GeoPointFieldType ft = new GeoPointFieldType(this.buildFullName(context), this.indexed, fieldType.stored(), this.hasDocValues, this.meta);
            ft.setGeometryParser(new AbstractPointGeometryFieldMapper.PointParser<ParsedGeoPoint>(this.name, ParsedGeoPoint::new, (parser, point) -> {
                GeoUtils.parseGeoPoint(parser, (GeoPoint)point, (boolean)this.ignoreZValue().value());
                return point;
            }, (ParsedGeoPoint)nullValue, ignoreZValue.value(), ignoreMalformed.value()));
            ft.setGeometryIndexer(new GeoPointIndexer(ft));
            return new GeoPointFieldMapper(this.name, fieldType, ft, multiFields, ignoreMalformed, ignoreZValue, nullValue, copyTo);
        }
    }
}

