/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.easysearch.common.lucene.BytesRefs;
import org.easysearch.common.lucene.search.AutomatonQueries;
import org.easysearch.index.mapper.SimpleMappedFieldType;
import org.easysearch.index.mapper.TextSearchInfo;
import org.easysearch.index.query.QueryShardContext;

public abstract class TermBasedFieldType
extends SimpleMappedFieldType {
    public TermBasedFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        super(name, isSearchable, isStored, hasDocValues, textSearchInfo, meta);
    }

    protected BytesRef indexedValueForSearch(Object value) {
        return BytesRefs.toBytesRef(value);
    }

    @Override
    public Query termQueryCaseInsensitive(Object value, QueryShardContext context) {
        this.failIfNotIndexed();
        AutomatonQuery query = AutomatonQueries.caseInsensitiveTermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
        if (this.boost() != 1.0f) {
            query = new BoostQuery((Query)query, this.boost());
        }
        return query;
    }

    @Override
    public Query termQuery(Object value, QueryShardContext context) {
        this.failIfNotIndexed();
        TermQuery query = new TermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
        if (this.boost() != 1.0f) {
            query = new BoostQuery((Query)query, this.boost());
        }
        return query;
    }

    @Override
    public Query termsQuery(List<?> values, QueryShardContext context) {
        this.failIfNotIndexed();
        BytesRef[] bytesRefs = new BytesRef[values.size()];
        for (int i = 0; i < bytesRefs.length; ++i) {
            bytesRefs[i] = this.indexedValueForSearch(values.get(i));
        }
        return new TermInSetQuery(this.name(), bytesRefs);
    }
}

