/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.indices.recovery;

import java.io.IOException;
import java.util.Objects;
import org.easysearch.EasysearchException;
import org.easysearch.EasysearchWrapperException;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.unit.ByteSizeValue;
import org.easysearch.index.shard.ShardId;

public class RecoverFilesRecoveryException
extends EasysearchException
implements EasysearchWrapperException {
    private final int numberOfFiles;
    private final ByteSizeValue totalFilesSize;

    public RecoverFilesRecoveryException(ShardId shardId, int numberOfFiles, ByteSizeValue totalFilesSize, Throwable cause) {
        super("Failed to transfer [{}] files with total size of [{}]", cause, numberOfFiles, totalFilesSize);
        Objects.requireNonNull(totalFilesSize, "totalFilesSize must not be null");
        this.setShard(shardId);
        this.numberOfFiles = numberOfFiles;
        this.totalFilesSize = totalFilesSize;
    }

    public int numberOfFiles() {
        return this.numberOfFiles;
    }

    public ByteSizeValue totalFilesSize() {
        return this.totalFilesSize;
    }

    public RecoverFilesRecoveryException(StreamInput in) throws IOException {
        super(in);
        this.numberOfFiles = in.readInt();
        this.totalFilesSize = new ByteSizeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.numberOfFiles);
        this.totalFilesSize.writeTo(out);
    }
}

