/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.indices.store;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.easysearch.EasysearchException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionType;
import org.easysearch.action.FailedNodeException;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.nodes.BaseNodeRequest;
import org.easysearch.action.support.nodes.BaseNodeResponse;
import org.easysearch.action.support.nodes.BaseNodesRequest;
import org.easysearch.action.support.nodes.BaseNodesResponse;
import org.easysearch.action.support.nodes.TransportNodesAction;
import org.easysearch.cluster.ClusterName;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.Nullable;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.settings.Settings;
import org.easysearch.env.NodeEnvironment;
import org.easysearch.gateway.AsyncShardFetch;
import org.easysearch.index.seqno.ReplicationTracker;
import org.easysearch.index.seqno.RetentionLease;
import org.easysearch.index.shard.ShardId;
import org.easysearch.index.store.Store;
import org.easysearch.index.store.StoreFileMetadata;
import org.easysearch.indices.IndicesService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportNodesListShardStoreMetadata
extends TransportNodesAction<Request, NodesStoreFilesMetadata, NodeRequest, NodeStoreFilesMetadata>
implements AsyncShardFetch.Lister<NodesStoreFilesMetadata, NodeStoreFilesMetadata> {
    public static final String ACTION_NAME = "internal:cluster/nodes/indices/shard/store";
    public static final ActionType<NodesStoreFilesMetadata> TYPE = new ActionType<NodesStoreFilesMetadata>("internal:cluster/nodes/indices/shard/store", NodesStoreFilesMetadata::new);
    private final Settings settings;
    private final IndicesService indicesService;
    private final NodeEnvironment nodeEnv;

    @Inject
    public TransportNodesListShardStoreMetadata(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, NodeEnvironment nodeEnv, ActionFilters actionFilters) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "fetch_shard_store", NodeStoreFilesMetadata.class);
        this.settings = settings;
        this.indicesService = indicesService;
        this.nodeEnv = nodeEnv;
    }

    @Override
    public void list(ShardId shardId, String customDataPath, DiscoveryNode[] nodes, ActionListener<NodesStoreFilesMetadata> listener) {
        this.execute(new Request(shardId, customDataPath, nodes), listener);
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeStoreFilesMetadata newNodeResponse(StreamInput in) throws IOException {
        return new NodeStoreFilesMetadata(in);
    }

    @Override
    protected NodesStoreFilesMetadata newResponse(Request request, List<NodeStoreFilesMetadata> responses, List<FailedNodeException> failures) {
        return new NodesStoreFilesMetadata(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeStoreFilesMetadata nodeOperation(NodeRequest request) {
        try {
            return new NodeStoreFilesMetadata(this.clusterService.localNode(), this.listStoreMetadata(request));
        }
        catch (IOException e) {
            throw new EasysearchException("Failed to list store metadata for shard [" + request.shardId + "]", (Throwable)e, new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private StoreFilesMetadata listStoreMetadata(NodeRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class NodeStoreFilesMetadata
    extends BaseNodeResponse {
        private StoreFilesMetadata storeFilesMetadata;

        public NodeStoreFilesMetadata(StreamInput in) throws IOException {
            super(in);
            this.storeFilesMetadata = new StoreFilesMetadata(in);
        }

        public NodeStoreFilesMetadata(DiscoveryNode node, StoreFilesMetadata storeFilesMetadata) {
            super(node);
            this.storeFilesMetadata = storeFilesMetadata;
        }

        public StoreFilesMetadata storeFilesMetadata() {
            return this.storeFilesMetadata;
        }

        public static NodeStoreFilesMetadata readListShardStoreNodeOperationResponse(StreamInput in) throws IOException {
            return new NodeStoreFilesMetadata(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.storeFilesMetadata.writeTo(out);
        }

        public String toString() {
            return "[[" + this.getNode() + "][" + this.storeFilesMetadata + "]]";
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.readString();
        }

        public Request(ShardId shardId, String customDataPath, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = Objects.requireNonNull(shardId);
            this.customDataPath = Objects.requireNonNull(customDataPath);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.customDataPath);
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.readString();
        }

        public NodeRequest(Request request) {
            this.shardId = Objects.requireNonNull(request.shardId());
            this.customDataPath = Objects.requireNonNull(request.getCustomDataPath());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            assert (this.customDataPath != null);
            out.writeString(this.customDataPath);
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }
    }

    public static class NodesStoreFilesMetadata
    extends BaseNodesResponse<NodeStoreFilesMetadata> {
        public NodesStoreFilesMetadata(StreamInput in) throws IOException {
            super(in);
        }

        public NodesStoreFilesMetadata(ClusterName clusterName, List<NodeStoreFilesMetadata> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeStoreFilesMetadata> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeStoreFilesMetadata::readListShardStoreNodeOperationResponse);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeStoreFilesMetadata> nodes) throws IOException {
            out.writeList(nodes);
        }
    }

    public static class StoreFilesMetadata
    implements Iterable<StoreFileMetadata>,
    Writeable {
        private final ShardId shardId;
        private final Store.MetadataSnapshot metadataSnapshot;
        private final List<RetentionLease> peerRecoveryRetentionLeases;

        public StoreFilesMetadata(ShardId shardId, Store.MetadataSnapshot metadataSnapshot, List<RetentionLease> peerRecoveryRetentionLeases) {
            this.shardId = shardId;
            this.metadataSnapshot = metadataSnapshot;
            this.peerRecoveryRetentionLeases = peerRecoveryRetentionLeases;
        }

        public StoreFilesMetadata(StreamInput in) throws IOException {
            this.shardId = new ShardId(in);
            this.metadataSnapshot = new Store.MetadataSnapshot(in);
            this.peerRecoveryRetentionLeases = in.readList(RetentionLease::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.shardId.writeTo(out);
            this.metadataSnapshot.writeTo(out);
            out.writeList(this.peerRecoveryRetentionLeases);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public boolean isEmpty() {
            return this.metadataSnapshot.size() == 0;
        }

        @Override
        public Iterator<StoreFileMetadata> iterator() {
            return this.metadataSnapshot.iterator();
        }

        public boolean fileExists(String name) {
            return this.metadataSnapshot.asMap().containsKey(name);
        }

        public StoreFileMetadata file(String name) {
            return this.metadataSnapshot.asMap().get(name);
        }

        public long getPeerRecoveryRetentionLeaseRetainingSeqNo(DiscoveryNode node) {
            assert (node != null);
            String retentionLeaseId = ReplicationTracker.getPeerRecoveryRetentionLeaseId(node.getId());
            return this.peerRecoveryRetentionLeases.stream().filter(lease -> lease.id().equals(retentionLeaseId)).mapToLong(RetentionLease::retainingSequenceNumber).findFirst().orElse(-1L);
        }

        public List<RetentionLease> peerRecoveryRetentionLeases() {
            return this.peerRecoveryRetentionLeases;
        }

        public String syncId() {
            return this.metadataSnapshot.getSyncId();
        }

        public String toString() {
            return "StoreFilesMetadata{, shardId=" + this.shardId + ", metadataSnapshot{size=" + this.metadataSnapshot.size() + ", syncId=" + this.metadataSnapshot.getSyncId() + "}}";
        }
    }
}

