/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.easysearch.action.admin.indices.open.OpenIndexRequest;
import org.easysearch.action.admin.indices.open.OpenIndexResponse;
import org.easysearch.action.support.ActiveShardCount;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.Strings;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.action.RestToXContentListener;

public class RestOpenIndexAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_open"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_open")));
    }

    @Override
    public String getName() {
        return "open_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        OpenIndexRequest openIndexRequest = new OpenIndexRequest(Strings.splitStringByCommaToArray(request.param("index")));
        openIndexRequest.timeout(request.paramAsTime("timeout", openIndexRequest.timeout()));
        openIndexRequest.masterNodeTimeout(request.paramAsTime("master_timeout", openIndexRequest.masterNodeTimeout()));
        openIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, openIndexRequest.indicesOptions()));
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            openIndexRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
        return channel -> client.admin().indices().open(openIndexRequest, new RestToXContentListener<OpenIndexResponse>((RestChannel)channel));
    }
}

