/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations;

import java.io.IOException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;

public abstract class LeafBucketCollector
implements LeafCollector {
    public static final LeafBucketCollector NO_OP_COLLECTOR = new LeafBucketCollector(){

        @Override
        public void setScorer(Scorable arg0) throws IOException {
        }

        @Override
        public void collect(int doc, long bucket) {
        }
    };

    public static LeafBucketCollector wrap(Iterable<LeafBucketCollector> collectors) {
        Stream<LeafBucketCollector> actualCollectors = StreamSupport.stream(collectors.spliterator(), false).filter(c -> c != NO_OP_COLLECTOR);
        final LeafBucketCollector[] colls = (LeafBucketCollector[])actualCollectors.toArray(LeafBucketCollector[]::new);
        switch (colls.length) {
            case 0: {
                return NO_OP_COLLECTOR;
            }
            case 1: {
                return colls[0];
            }
        }
        return new LeafBucketCollector(){

            @Override
            public void setScorer(Scorable s2) throws IOException {
                for (LeafBucketCollector c : colls) {
                    c.setScorer(s2);
                }
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                for (LeafBucketCollector c : colls) {
                    c.collect(doc, bucket);
                }
            }
        };
    }

    public abstract void collect(int var1, long var2) throws IOException;

    public final void collect(int doc) throws IOException {
        this.collect(doc, 0L);
    }

    public void setScorer(Scorable scorer) throws IOException {
    }
}

