/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Objects;
import org.easysearch.common.ParseField;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.InstantiatingObjectParser;
import org.easysearch.common.xcontent.ObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;

public class DoubleBounds
implements ToXContentFragment,
Writeable {
    static final ParseField MIN_FIELD = new ParseField("min", new String[0]);
    static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    static final InstantiatingObjectParser<DoubleBounds, Void> PARSER;
    private final Double min;
    private final Double max;

    public DoubleBounds(Double min2, Double max) {
        if (min2 != null && !Double.isFinite(min2)) {
            throw new IllegalArgumentException("min bound must be finite, got: " + min2);
        }
        if (max != null && !Double.isFinite(max)) {
            throw new IllegalArgumentException("max bound must be finite, got: " + max);
        }
        if (max != null && min2 != null && max < min2) {
            throw new IllegalArgumentException("max bound [" + max + "] must be greater than min bound [" + min2 + "]");
        }
        this.min = min2;
        this.max = max;
    }

    public DoubleBounds(StreamInput in) throws IOException {
        this.min = in.readOptionalDouble();
        this.max = in.readOptionalDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalDouble(this.min);
        out.writeOptionalDouble(this.max);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.min != null) {
            builder.field(MIN_FIELD.getPreferredName(), this.min);
        }
        if (this.max != null) {
            builder.field(MAX_FIELD.getPreferredName(), this.max);
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleBounds other = (DoubleBounds)obj;
        return Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public static double getEffectiveMin(DoubleBounds bounds) {
        return bounds == null || bounds.min == null ? Double.POSITIVE_INFINITY : bounds.min;
    }

    public static Double getEffectiveMax(DoubleBounds bounds) {
        return bounds == null || bounds.max == null ? Double.NEGATIVE_INFINITY : bounds.max;
    }

    public boolean contain(double value) {
        if (this.max != null && value > this.max) {
            return false;
        }
        return this.min == null || !(value < this.min);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.min != null) {
            b.append(this.min);
        }
        b.append("--");
        if (this.max != null) {
            b.append(this.max);
        }
        return b.toString();
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder("double_bounds", false, DoubleBounds.class);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : Double.valueOf(p.doubleValue()), MIN_FIELD, ObjectParser.ValueType.DOUBLE_OR_NULL);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : Double.valueOf(p.doubleValue()), MAX_FIELD, ObjectParser.ValueType.DOUBLE_OR_NULL);
        PARSER = parser.build();
    }
}

