/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.nested;

import java.io.IOException;
import java.util.Map;
import org.easysearch.index.mapper.ObjectMapper;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.NonCollectingAggregator;
import org.easysearch.search.aggregations.bucket.nested.InternalNested;
import org.easysearch.search.aggregations.bucket.nested.NestedAggregator;
import org.easysearch.search.internal.SearchContext;

public class NestedAggregatorFactory
extends AggregatorFactory {
    private final ObjectMapper parentObjectMapper;
    private final ObjectMapper childObjectMapper;

    NestedAggregatorFactory(String name, ObjectMapper parentObjectMapper, ObjectMapper childObjectMapper, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactories, metadata);
        this.parentObjectMapper = parentObjectMapper;
        this.childObjectMapper = childObjectMapper;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (this.childObjectMapper == null) {
            return new Unmapped(this.name, searchContext, parent, this.factories, metadata);
        }
        return new NestedAggregator(this.name, this.factories, this.parentObjectMapper, this.childObjectMapper, searchContext, parent, cardinality, metadata);
    }

    private static final class Unmapped
    extends NonCollectingAggregator {
        Unmapped(String name, SearchContext context, Aggregator parent, AggregatorFactories factories, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, factories, metadata);
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            return new InternalNested(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
        }
    }
}

