/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.metrics.AbstractHDRPercentilesAggregator;
import org.easysearch.search.aggregations.metrics.InternalHDRPercentileRanks;
import org.easysearch.search.aggregations.support.ValuesSource;
import org.easysearch.search.internal.SearchContext;

class HDRPercentileRanksAggregator
extends AbstractHDRPercentilesAggregator {
    HDRPercentileRanksAggregator(String name, ValuesSource valuesSource, SearchContext context, Aggregator parent, double[] percents, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat format, Map<String, Object> metadata) throws IOException {
        super(name, valuesSource, context, parent, percents, numberOfSignificantValueDigits, keyed, format, metadata);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        DoubleHistogram state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalHDRPercentileRanks(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        DoubleHistogram state = new DoubleHistogram(this.numberOfSignificantValueDigits);
        state.setAutoResize(true);
        return new InternalHDRPercentileRanks(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        DoubleHistogram state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return InternalHDRPercentileRanks.percentileRank(state, Double.valueOf(name));
    }
}

