/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.pipeline.BucketHelpers;
import org.easysearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.InternalBucketMetricValue;

public class MinBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private List<String> minBucketKeys;
    private double minValue;

    MinBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, gapPolicy, formatter, metadata);
    }

    public MinBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "min_bucket";
    }

    @Override
    protected void preCollection() {
        this.minBucketKeys = new ArrayList<String>();
        this.minValue = Double.POSITIVE_INFINITY;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        if (bucketValue < this.minValue) {
            this.minBucketKeys.clear();
            this.minBucketKeys.add(bucketKey);
            this.minValue = bucketValue;
        } else if (bucketValue.equals(this.minValue)) {
            this.minBucketKeys.add(bucketKey);
        }
    }

    @Override
    protected InternalAggregation buildAggregation(Map<String, Object> metadata) {
        String[] keys = this.minBucketKeys.toArray(new String[0]);
        return new InternalBucketMetricValue(this.name(), keys, this.minValue, this.format, this.metadata());
    }
}

