/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.query;

import java.io.IOException;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.search.SearchPhaseResult;
import org.easysearch.search.SearchShardTarget;
import org.easysearch.search.query.QuerySearchResult;

public final class ScrollQuerySearchResult
extends SearchPhaseResult {
    private final QuerySearchResult result;

    public ScrollQuerySearchResult(StreamInput in) throws IOException {
        super(in);
        SearchShardTarget shardTarget = new SearchShardTarget(in);
        this.result = new QuerySearchResult(in);
        this.setSearchShardTarget(shardTarget);
    }

    public ScrollQuerySearchResult(QuerySearchResult result, SearchShardTarget shardTarget) {
        this.result = result;
        this.setSearchShardTarget(shardTarget);
    }

    @Override
    public void setSearchShardTarget(SearchShardTarget shardTarget) {
        super.setSearchShardTarget(shardTarget);
        this.result.setSearchShardTarget(shardTarget);
    }

    @Override
    public void setShardIndex(int shardIndex) {
        super.setShardIndex(shardIndex);
        this.result.setShardIndex(shardIndex);
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.result;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.getSearchShardTarget().writeTo(out);
        this.result.writeTo(out);
    }
}

