/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.easysearch.catalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigUtil;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.InfoPreviewResult;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PreviewResult;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.connectors.seatunnel.easysearch.catalog.EasysearchDataTypeConvertor;
import org.apache.seatunnel.connectors.seatunnel.easysearch.client.EasysearchClient;
import org.apache.seatunnel.connectors.seatunnel.easysearch.dto.EasysearchClusterInfo;
import org.apache.seatunnel.connectors.seatunnel.easysearch.dto.source.IndexDocsCount;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasysearchCatalog
implements Catalog {
    private static final Logger log = LoggerFactory.getLogger(EasysearchCatalog.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(EasysearchCatalog.class);
    private final String catalogName;
    private final String defaultDatabase;
    private final ReadonlyConfig pluginConfig;
    private EasysearchClient ezsClient;

    public EasysearchCatalog(String catalogName, String defaultDatabase, ReadonlyConfig easySearchConfig) {
        this.catalogName = (String)Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName cannot be null");
        this.defaultDatabase = defaultDatabase;
        this.pluginConfig = (ReadonlyConfig)Preconditions.checkNotNull((Object)easySearchConfig, (Object)"easySearchConfig cannot be null");
    }

    public void open() throws CatalogException {
        try {
            this.ezsClient = EasysearchClient.createInstance(this.pluginConfig);
            EasysearchClusterInfo easysearchClusterInfo = this.ezsClient.getClusterInfo();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Success open ezs catalog: {}, cluster info: {}", (Object)this.catalogName, (Object)easysearchClusterInfo);
            }
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed to open catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public void close() throws CatalogException {
        this.ezsClient.close();
    }

    public String name() {
        return this.catalogName;
    }

    public String getDefaultDatabase() throws CatalogException {
        return this.defaultDatabase;
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            return this.ezsClient.checkIndexExist(databaseName);
        }
        catch (Exception e) {
            log.error(String.format("Failed to check if catalog %s database %s exists", this.catalogName, databaseName), (Throwable)e);
            return false;
        }
    }

    public List<String> listDatabases() throws CatalogException {
        return this.ezsClient.listIndex();
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        return Lists.newArrayList((Object[])new String[]{databaseName});
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        Preconditions.checkNotNull((Object)tablePath);
        return this.databaseExists(tablePath.getTableName());
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath cannot be null");
        EasysearchDataTypeConvertor easySearchDataTypeConvertor = new EasysearchDataTypeConvertor();
        TableSchema.Builder builder = TableSchema.builder();
        Map<String, String> fieldTypeMapping = this.ezsClient.getFieldTypeMapping(tablePath.getTableName(), Collections.emptyList());
        fieldTypeMapping.forEach((fieldName, fieldType) -> {
            PhysicalColumn physicalColumn = PhysicalColumn.of((String)fieldName, easySearchDataTypeConvertor.toSeaTunnelType((String)fieldName, (String)fieldType), (Long)null, (boolean)true, null, null);
            builder.column((Column)physicalColumn);
        });
        return CatalogTable.of((TableIdentifier)TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName()), (TableSchema)builder.build(), this.buildTableOptions(tablePath), Collections.emptyList(), (String)"");
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath cannot be null");
        if (this.tableExists(tablePath)) {
            if (!ignoreIfExists) {
                throw new TableAlreadyExistException(this.catalogName, tablePath, null);
            }
            return;
        }
        this.ezsClient.createIndex(tablePath.getTableName());
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath);
        if (!this.tableExists(tablePath)) {
            if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.catalogName, tablePath);
            }
            return;
        }
        try {
            this.ezsClient.dropIndex(tablePath.getTableName());
        }
        catch (Exception ex) {
            throw new CatalogException(String.format("Failed to drop table %s in catalog %s", tablePath.getTableName(), this.catalogName), (Throwable)ex);
        }
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        try {
            this.createTable(tablePath, null, ignoreIfExists);
        }
        catch (TableAlreadyExistException ex) {
            throw new DatabaseAlreadyExistException(this.catalogName, tablePath.getDatabaseName());
        }
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        try {
            this.dropTable(tablePath, ignoreIfNotExists);
        }
        catch (TableNotExistException ex) {
            throw new DatabaseNotExistException(this.catalogName, tablePath.getDatabaseName());
        }
    }

    public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) {
        try {
            this.dropTable(tablePath, ignoreIfNotExists);
            this.createTable(tablePath, null, false);
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed to truncate table %s in catalog %s", tablePath.getTableName(), this.catalogName), (Throwable)e);
        }
    }

    public boolean isExistsData(TablePath tablePath) {
        try {
            if (!this.ezsClient.checkIndexExist(tablePath.getTableName())) {
                return false;
            }
            List<IndexDocsCount> indexDocsCount = this.ezsClient.getIndexDocsCount(tablePath.getTableName());
            return !indexDocsCount.isEmpty() && indexDocsCount.get(0).getDocsCount() > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public PreviewResult previewAction(Catalog.ActionType actionType, TablePath tablePath, Optional<CatalogTable> catalogTable) {
        if (actionType == Catalog.ActionType.CREATE_TABLE) {
            return new InfoPreviewResult("create index " + tablePath.getTableName());
        }
        if (actionType == Catalog.ActionType.DROP_TABLE) {
            return new InfoPreviewResult("delete index " + tablePath.getTableName());
        }
        if (actionType == Catalog.ActionType.TRUNCATE_TABLE) {
            return new InfoPreviewResult("delete and create index " + tablePath.getTableName());
        }
        if (actionType == Catalog.ActionType.CREATE_DATABASE) {
            return new InfoPreviewResult("create index " + tablePath.getTableName());
        }
        if (actionType == Catalog.ActionType.DROP_DATABASE) {
            return new InfoPreviewResult("delete index " + tablePath.getTableName());
        }
        throw new UnsupportedOperationException("Unsupported action type: " + actionType);
    }

    private Map<String, String> buildTableOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "easysearch");
        options.put("config", ConfigUtil.convertToJsonString((Object)tablePath));
        return options;
    }
}

