/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.easysearch.catalog;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

@AutoService(value={DataTypeConvertor.class})
public class EasysearchDataTypeConvertor
implements DataTypeConvertor<String> {
    public static final String STRING = "string";
    public static final String KEYWORD = "keyword";
    public static final String TEXT = "text";
    public static final String BOOLEAN = "boolean";
    public static final String BYTE = "byte";
    public static final String SHORT = "short";
    public static final String INTEGER = "integer";
    public static final String LONG = "long";
    public static final String FLOAT = "float";
    public static final String HALF_FLOAT = "half_float";
    public static final String DOUBLE = "double";
    public static final String DATE = "date";

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String connectorDataType) {
        return this.toSeaTunnelType(field, connectorDataType, null);
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String connectorDataType, Map<String, Object> dataTypeProperties) {
        Preconditions.checkNotNull((Object)connectorDataType, (Object)"connectorDataType can not be null");
        switch (connectorDataType) {
            case "string": {
                return BasicType.STRING_TYPE;
            }
            case "keyword": {
                return BasicType.STRING_TYPE;
            }
            case "text": {
                return BasicType.STRING_TYPE;
            }
            case "boolean": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "byte": {
                return BasicType.BYTE_TYPE;
            }
            case "short": {
                return BasicType.SHORT_TYPE;
            }
            case "integer": {
                return BasicType.INT_TYPE;
            }
            case "long": {
                return BasicType.LONG_TYPE;
            }
            case "float": {
                return BasicType.FLOAT_TYPE;
            }
            case "half_float": {
                return BasicType.FLOAT_TYPE;
            }
            case "double": {
                return BasicType.DOUBLE_TYPE;
            }
            case "date": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
        }
        return BasicType.STRING_TYPE;
    }

    public String toConnectorType(String field, SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) {
        Preconditions.checkNotNull(seaTunnelDataType, (Object)"seaTunnelDataType can not be null");
        SqlType sqlType = seaTunnelDataType.getSqlType();
        switch (sqlType) {
            case STRING: {
                return STRING;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case BYTES: {
                return BYTE;
            }
            case TINYINT: {
                return SHORT;
            }
            case INT: {
                return INTEGER;
            }
            case BIGINT: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case TIMESTAMP: {
                return DATE;
            }
        }
        return STRING;
    }

    public String getIdentity() {
        return "Easysearch";
    }
}

