/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.easysearch.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.easysearch.catalog.EasysearchDataTypeConvertor;
import org.apache.seatunnel.connectors.seatunnel.easysearch.client.EasysearchClient;
import org.apache.seatunnel.connectors.seatunnel.easysearch.config.EasysearchSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.easysearch.source.EasysearchSource;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;

@AutoService(value={Factory.class})
public class EasysearchSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Easysearch";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{EasysearchSourceOptions.HOSTS, EasysearchSourceOptions.INDEX}).optional(new Option[]{EasysearchSourceOptions.USERNAME, EasysearchSourceOptions.PASSWORD, EasysearchSourceOptions.SCROLL_TIME, EasysearchSourceOptions.SCROLL_SIZE, EasysearchSourceOptions.QUERY, EasysearchSourceOptions.TLS_VERIFY_CERTIFICATE, EasysearchSourceOptions.TLS_VERIFY_HOSTNAME, EasysearchSourceOptions.TLS_KEY_STORE_PATH, EasysearchSourceOptions.TLS_KEY_STORE_PASSWORD, EasysearchSourceOptions.TLS_TRUST_STORE_PATH, EasysearchSourceOptions.TLS_TRUST_STORE_PASSWORD}).exclusive(new Option[]{EasysearchSourceOptions.SOURCE, ConnectorCommonOptions.SCHEMA}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        List<Object> source;
        CatalogTable catalogTable;
        ReadonlyConfig contextOptions = context.getOptions();
        if (contextOptions.getOptional(ConnectorCommonOptions.SCHEMA).isPresent()) {
            catalogTable = CatalogTableUtil.buildWithConfig((ReadonlyConfig)contextOptions);
            source = Arrays.asList(CatalogTableUtil.buildWithConfig((ReadonlyConfig)contextOptions).getSeaTunnelRowType().getFieldNames());
        } else {
            source = contextOptions.getOptional(EasysearchSourceOptions.SOURCE).isPresent() ? (List)contextOptions.get(EasysearchSourceOptions.SOURCE) : Lists.newArrayList();
            EasysearchClient ezsClient = EasysearchClient.createInstance(contextOptions);
            Map<String, String> ezsFieldType = ezsClient.getFieldTypeMapping((String)contextOptions.get(EasysearchSourceOptions.INDEX), source);
            ezsClient.close();
            EasysearchDataTypeConvertor easySearchDataTypeConvertor = new EasysearchDataTypeConvertor();
            ArrayList<PhysicalColumn> columns = new ArrayList<PhysicalColumn>();
            if (CollectionUtils.isEmpty((Collection)source)) {
                ArrayList<String> keys = new ArrayList<String>(ezsFieldType.keySet());
                for (int i = 0; i < keys.size(); ++i) {
                    String esType = ezsFieldType.get(keys.get(i));
                    PhysicalColumn physicalColumn = PhysicalColumn.of((String)((String)keys.get(i)), easySearchDataTypeConvertor.toSeaTunnelType((String)keys.get(i), esType), null, null, (boolean)true, null, null);
                    columns.add(physicalColumn);
                }
            } else {
                for (int i = 0; i < source.size(); ++i) {
                    String esType = ezsFieldType.get(source.get(i));
                    PhysicalColumn physicalColumn = PhysicalColumn.of((String)((String)source.get(i)), easySearchDataTypeConvertor.toSeaTunnelType((String)source.get(i), esType), null, null, (boolean)true, null, null);
                    columns.add(physicalColumn);
                }
            }
            catalogTable = CatalogTable.of((TableIdentifier)TableIdentifier.of((String)"default", (String)"default", (String)"default"), (TableSchema)TableSchema.builder().columns(columns).build(), Collections.emptyMap(), Collections.emptyList(), (String)"");
        }
        return () -> new EasysearchSource(contextOptions, source, catalogTable);
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return EasysearchSource.class;
    }
}

