/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.easysearch.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.easysearch.client.EasysearchClient;
import org.apache.seatunnel.connectors.seatunnel.easysearch.config.EasysearchSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.easysearch.dto.source.IndexDocsCount;
import org.apache.seatunnel.connectors.seatunnel.easysearch.dto.source.SourceIndexInfo;
import org.apache.seatunnel.connectors.seatunnel.easysearch.exception.EasysearchConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.easysearch.exception.EasysearchConnectorException;
import org.apache.seatunnel.connectors.seatunnel.easysearch.source.EasysearchSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.easysearch.source.EasysearchSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasysearchSourceSplitEnumerator
implements SourceSplitEnumerator<EasysearchSourceSplit, EasysearchSourceState> {
    private static final Logger log = LoggerFactory.getLogger(EasysearchSourceSplitEnumerator.class);
    private final Object stateLock = new Object();
    private final SourceSplitEnumerator.Context<EasysearchSourceSplit> context;
    private final ReadonlyConfig pluginConfig;
    private final Map<Integer, List<EasysearchSourceSplit>> pendingSplit;
    private final List<String> source;
    private EasysearchClient ezsClient;
    private volatile boolean shouldEnumerate;

    public EasysearchSourceSplitEnumerator(SourceSplitEnumerator.Context<EasysearchSourceSplit> context, ReadonlyConfig pluginConfig, List<String> source) {
        this(context, null, pluginConfig, source);
    }

    public EasysearchSourceSplitEnumerator(SourceSplitEnumerator.Context<EasysearchSourceSplit> context, EasysearchSourceState sourceState, ReadonlyConfig pluginConfig, List<String> source) {
        this.context = context;
        this.pluginConfig = pluginConfig;
        this.pendingSplit = new HashMap<Integer, List<EasysearchSourceSplit>>();
        boolean bl = this.shouldEnumerate = sourceState == null;
        if (sourceState != null) {
            this.shouldEnumerate = sourceState.isShouldEnumerate();
            this.pendingSplit.putAll(sourceState.getPendingSplit());
        }
        this.source = source;
    }

    private static int getSplitOwner(String tp, int numReaders) {
        return (tp.hashCode() & Integer.MAX_VALUE) % numReaders;
    }

    public void open() {
        this.ezsClient = EasysearchClient.createInstance(this.pluginConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Set readers = this.context.registeredReaders();
        if (this.shouldEnumerate) {
            List<EasysearchSourceSplit> newSplits = this.getEasysearchSplit();
            Object object = this.stateLock;
            synchronized (object) {
                this.addPendingSplit(newSplits);
                this.shouldEnumerate = false;
            }
            this.assignSplit(readers);
        }
        log.debug("No more splits to assign. Sending NoMoreSplitsEvent to reader {}.", (Object)readers);
        readers.forEach(arg_0 -> this.context.signalNoMoreSplits(arg_0));
    }

    private void addPendingSplit(Collection<EasysearchSourceSplit> splits) {
        int readerCount = this.context.currentParallelism();
        for (EasysearchSourceSplit split : splits) {
            int ownerReader = EasysearchSourceSplitEnumerator.getSplitOwner(split.splitId(), readerCount);
            log.info("Assigning {} to {} reader.", (Object)split, (Object)ownerReader);
            this.pendingSplit.computeIfAbsent(ownerReader, r -> new ArrayList()).add(split);
        }
    }

    private void assignSplit(Collection<Integer> readers) {
        log.debug("Assign pendingSplits to readers {}", readers);
        for (int reader : readers) {
            List<EasysearchSourceSplit> assignmentForReader = this.pendingSplit.remove(reader);
            if (assignmentForReader == null || assignmentForReader.isEmpty()) continue;
            log.info("Assign splits {} to reader {}", assignmentForReader, (Object)reader);
            try {
                this.context.assignSplit(reader, assignmentForReader);
            }
            catch (Exception e) {
                log.error("Failed to assign splits {} to reader {}", new Object[]{assignmentForReader, reader, e});
                this.pendingSplit.put(reader, assignmentForReader);
            }
        }
    }

    private List<EasysearchSourceSplit> getEasysearchSplit() {
        ArrayList<EasysearchSourceSplit> splits = new ArrayList<EasysearchSourceSplit>();
        String scrollTime = (String)this.pluginConfig.get(EasysearchSourceOptions.SCROLL_TIME);
        int scrollSize = (Integer)this.pluginConfig.get(EasysearchSourceOptions.SCROLL_SIZE);
        Map query = (Map)this.pluginConfig.get(EasysearchSourceOptions.QUERY);
        List<IndexDocsCount> indexDocsCounts = this.ezsClient.getIndexDocsCount((String)this.pluginConfig.get(EasysearchSourceOptions.INDEX));
        indexDocsCounts = indexDocsCounts.stream().filter(x -> x.getDocsCount() != null && x.getDocsCount() > 0L).sorted(Comparator.comparingLong(IndexDocsCount::getDocsCount)).collect(Collectors.toList());
        for (IndexDocsCount indexDocsCount : indexDocsCounts) {
            splits.add(new EasysearchSourceSplit(String.valueOf(indexDocsCount.getIndex().hashCode()), new SourceIndexInfo(indexDocsCount.getIndex(), this.source, query, scrollTime, scrollSize)));
        }
        return splits;
    }

    public void close() throws IOException {
        this.ezsClient.close();
    }

    public void addSplitsBack(List<EasysearchSourceSplit> splits, int subtaskId) {
        if (!splits.isEmpty()) {
            this.addPendingSplit(splits);
            this.assignSplit(Collections.singletonList(subtaskId));
        }
    }

    public int currentUnassignedSplitSize() {
        return this.pendingSplit.size();
    }

    public void handleSplitRequest(int subtaskId) {
        throw new EasysearchConnectorException((SeaTunnelErrorCode)EasysearchConnectorErrorCode.UNSUPPORTED_OPERATION, "Unsupported handleSplitRequest: " + subtaskId);
    }

    public void registerReader(int subtaskId) {
        log.debug("Register reader {} to EasysearchSourceSplitEnumerator.", (Object)subtaskId);
        if (!this.pendingSplit.isEmpty()) {
            this.assignSplit(Collections.singletonList(subtaskId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EasysearchSourceState snapshotState(long checkpointId) throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            return new EasysearchSourceState(this.shouldEnumerate, this.pendingSplit);
        }
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

