/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.debezium;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.format.json.exception.SeaTunnelJsonFormatException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;

public class DebeziumRowConverter
implements Serializable {
    private static final String DECIMAL_SCALE_KEY = "scale";
    private static final String DECIMAL_VALUE_KEY = "value";
    private final Map<String, DateTimeFormatter> fieldFormatterMap = new HashMap<String, DateTimeFormatter>();
    private final SeaTunnelRowType rowType;

    public DebeziumRowConverter(SeaTunnelRowType rowType) {
        this.rowType = rowType;
    }

    public SeaTunnelRow parse(JsonNode node) throws IOException {
        return (SeaTunnelRow)this.getValue(null, (SeaTunnelDataType<?>)this.rowType, node);
    }

    private Object getValue(String fieldName, SeaTunnelDataType<?> dataType, JsonNode value) throws IOException {
        SqlType sqlType = dataType.getSqlType();
        if (value == null || value.isNull()) {
            return null;
        }
        switch (sqlType) {
            case BOOLEAN: {
                return value.asBoolean();
            }
            case TINYINT: {
                return (byte)value.asInt();
            }
            case SMALLINT: {
                return (short)value.asInt();
            }
            case INT: {
                return value.asInt();
            }
            case BIGINT: {
                return value.asLong();
            }
            case FLOAT: {
                return Float.valueOf(value.floatValue());
            }
            case DOUBLE: {
                return value.doubleValue();
            }
            case DECIMAL: {
                if (value.isNumber()) {
                    return value.decimalValue();
                }
                if (value.isBinary() || value.isTextual()) {
                    try {
                        return new BigDecimal(new BigInteger(value.binaryValue()), ((DecimalType)dataType).getScale());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Invalid bytes for Decimal field", e);
                    }
                }
                if (value.has(DECIMAL_SCALE_KEY)) {
                    return new BigDecimal(new BigInteger(value.get(DECIMAL_VALUE_KEY).binaryValue()), value.get(DECIMAL_SCALE_KEY).intValue());
                }
                return new BigDecimal(value.asText());
            }
            case STRING: {
                return value.asText();
            }
            case BYTES: {
                try {
                    return value.binaryValue();
                }
                catch (IOException e) {
                    throw new RuntimeException("Invalid bytes field", e);
                }
            }
            case DATE: {
                String dateStr = value.asText();
                if (value.canConvertToLong()) {
                    return LocalDate.ofEpochDay(Long.parseLong(dateStr));
                }
                DateTimeFormatter dateFormatter = this.fieldFormatterMap.get(fieldName);
                if (dateFormatter == null) {
                    dateFormatter = DateUtils.matchDateFormatter((String)dateStr);
                    this.fieldFormatterMap.put(fieldName, dateFormatter);
                }
                if (dateFormatter == null) {
                    throw new SeaTunnelJsonFormatException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel can not parse this date format [%s] of field [%s]", dateStr, fieldName));
                }
                return dateFormatter.parse(dateStr).query(TemporalQueries.localDate());
            }
            case TIME: {
                String timeStr = value.asText();
                if (value.canConvertToLong()) {
                    long time = Long.parseLong(timeStr);
                    if (timeStr.length() == 8) {
                        time = TimeUnit.SECONDS.toMicros(time);
                    } else if (timeStr.length() == 11) {
                        time = TimeUnit.MILLISECONDS.toMicros(time);
                    }
                    return LocalTime.ofNanoOfDay(time);
                }
                DateTimeFormatter timeFormatter = this.fieldFormatterMap.get(fieldName);
                if (timeFormatter == null) {
                    timeFormatter = DateUtils.matchDateFormatter((String)timeStr);
                    this.fieldFormatterMap.put(fieldName, timeFormatter);
                }
                if (timeFormatter == null) {
                    throw new SeaTunnelJsonFormatException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel can not parse this date format [%s] of field [%s]", timeStr, fieldName));
                }
                TemporalAccessor parsedTime = timeFormatter.parse(timeStr);
                return parsedTime.query(TemporalQueries.localTime());
            }
            case TIMESTAMP: {
                String timestampStr = value.asText();
                if (value.canConvertToLong()) {
                    long timestamp = Long.parseLong(value.toString());
                    if (timestampStr.length() > 16) {
                        timestamp = TimeUnit.NANOSECONDS.toMillis(timestamp);
                    } else if (timestampStr.length() > 13) {
                        timestamp = TimeUnit.MICROSECONDS.toMillis(timestamp);
                    } else if (timestampStr.length() <= 10) {
                        timestamp = TimeUnit.SECONDS.toMillis(timestamp);
                    }
                    return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC);
                }
                DateTimeFormatter timestampFormatter = this.fieldFormatterMap.get(fieldName);
                if (timestampFormatter == null) {
                    timestampFormatter = DateUtils.matchDateFormatter((String)timestampStr);
                    this.fieldFormatterMap.put(fieldName, timestampFormatter);
                }
                if (timestampFormatter == null) {
                    throw new SeaTunnelJsonFormatException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel can not parse this date format [%s] of field [%s]", timestampStr, fieldName));
                }
                TemporalAccessor parsedTimestamp = timestampFormatter.parse(timestampStr);
                LocalTime localTime = parsedTimestamp.query(TemporalQueries.localTime());
                LocalDate localDate = parsedTimestamp.query(TemporalQueries.localDate());
                return LocalDateTime.of(localDate, localTime);
            }
            case ARRAY: {
                ArrayList<Object> arrayValue = new ArrayList<Object>();
                for (JsonNode o : value) {
                    arrayValue.add(this.getValue(fieldName, ((ArrayType)dataType).getElementType(), o));
                }
                return arrayValue;
            }
            case MAP: {
                LinkedHashMap mapValue = new LinkedHashMap();
                Iterator it = value.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    mapValue.put(entry.getKey(), this.getValue(null, ((MapType)dataType).getValueType(), (JsonNode)entry.getValue()));
                }
                return mapValue;
            }
            case ROW: {
                SeaTunnelRowType rowType = (SeaTunnelRowType)dataType;
                SeaTunnelRow row = new SeaTunnelRow(rowType.getTotalFields());
                for (int i = 0; i < rowType.getTotalFields(); ++i) {
                    row.setField(i, this.getValue(rowType.getFieldName(i), rowType.getFieldType(i), value.has(rowType.getFieldName(i)) ? value.get(rowType.getFieldName(i)) : null));
                }
                return row;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + sqlType);
    }
}

