/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action;

import java.util.concurrent.CountDownLatch;
import org.easysearch.action.ActionListener;

public class LatchedActionListener<T>
implements ActionListener<T> {
    private final ActionListener<T> delegate;
    private final CountDownLatch latch;

    public LatchedActionListener(ActionListener<T> delegate, CountDownLatch latch) {
        this.delegate = delegate;
        this.latch = latch;
    }

    @Override
    public void onResponse(T t) {
        try {
            this.delegate.onResponse(t);
        }
        finally {
            this.latch.countDown();
        }
    }

    @Override
    public void onFailure(Exception e) {
        try {
            this.delegate.onFailure(e);
        }
        finally {
            this.latch.countDown();
        }
    }
}

