/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.action.support.master.TransportMasterNodeAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.script.ScriptService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportPutStoredScriptAction
extends TransportMasterNodeAction<PutStoredScriptRequest, AcknowledgedResponse> {
    private final ScriptService scriptService;

    @Inject
    public TransportPutStoredScriptAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService) {
        super("cluster:admin/script/put", transportService, clusterService, threadPool, actionFilters, PutStoredScriptRequest::new, indexNameExpressionResolver);
        this.scriptService = scriptService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(PutStoredScriptRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.scriptService.putStoredScript(this.clusterService, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(PutStoredScriptRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

