/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.diskusage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.easysearch.action.ActionListener;
import org.easysearch.action.NoShardAvailableActionException;
import org.easysearch.action.admin.indices.diskusage.AnalyzeIndexSpaceUsageRequest;
import org.easysearch.action.admin.indices.diskusage.AnalyzeIndexSpaceUsageResponse;
import org.easysearch.action.admin.indices.diskusage.AnalyzeSpaceUsageShardRequest;
import org.easysearch.action.admin.indices.diskusage.AnalyzeSpaceUsageShardResponse;
import org.easysearch.action.admin.indices.diskusage.IndexSpaceUsageAnalyzer;
import org.easysearch.action.admin.indices.diskusage.IndexSpaceUsageStats;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.DefaultShardOperationFailedException;
import org.easysearch.action.support.broadcast.TransportBroadcastAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.routing.GroupShardsIterator;
import org.easysearch.cluster.routing.ShardIterator;
import org.easysearch.cluster.routing.ShardRouting;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.engine.Engine;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.index.shard.ShardId;
import org.easysearch.indices.IndicesService;
import org.easysearch.tasks.CancellableTask;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskCancelledException;
import org.easysearch.transport.TransportService;

public class TransportAnalyzeIndexSpaceUsageAction
extends TransportBroadcastAction<AnalyzeIndexSpaceUsageRequest, AnalyzeIndexSpaceUsageResponse, AnalyzeSpaceUsageShardRequest, AnalyzeSpaceUsageShardResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportAnalyzeIndexSpaceUsageAction(ClusterService clusterService, TransportService transportService, IndicesService indexServices, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/analyze_space_usage", clusterService, transportService, actionFilters, indexNameExpressionResolver, AnalyzeIndexSpaceUsageRequest::new, AnalyzeSpaceUsageShardRequest::new, "analyze");
        this.indicesService = indexServices;
    }

    @Override
    protected void doExecute(Task task, AnalyzeIndexSpaceUsageRequest request, ActionListener<AnalyzeIndexSpaceUsageResponse> listener) {
        super.doExecute(task, request, listener);
    }

    @Override
    protected AnalyzeSpaceUsageShardRequest newShardRequest(int numShards, ShardRouting shard, AnalyzeIndexSpaceUsageRequest request) {
        return new AnalyzeSpaceUsageShardRequest(shard.shardId(), request);
    }

    @Override
    protected AnalyzeSpaceUsageShardResponse readShardResponse(StreamInput in) throws IOException {
        return new AnalyzeSpaceUsageShardResponse(in);
    }

    @Override
    protected AnalyzeSpaceUsageShardResponse shardOperation(AnalyzeSpaceUsageShardRequest request, Task task) throws IOException {
        ShardId shardId = request.shardId();
        assert (task instanceof CancellableTask) : "AnalyzeDiskUsageShardRequest must create a cancellable task";
        CancellableTask cancellableTask = (CancellableTask)task;
        Runnable checkForCancellation = () -> {
            if (cancellableTask.isCancelled()) {
                String reason = cancellableTask.getReasonCancelled();
                throw new TaskCancelledException(reason != null ? reason : "Task was cancelled");
            }
        };
        IndexShard shard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
        try (Engine.IndexCommitRef commitRef = shard.acquireLastIndexCommit(request.flush);){
            IndexSpaceUsageStats stats = IndexSpaceUsageAnalyzer.analyze(shardId, commitRef.getIndexCommit(), checkForCancellation);
            AnalyzeSpaceUsageShardResponse analyzeSpaceUsageShardResponse = new AnalyzeSpaceUsageShardResponse(shardId, stats);
            return analyzeSpaceUsageShardResponse;
        }
    }

    @Override
    protected AnalyzeIndexSpaceUsageResponse newResponse(AnalyzeIndexSpaceUsageRequest request, AtomicReferenceArray<?> shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = new ArrayList<DefaultShardOperationFailedException>();
        HashMap<String, IndexSpaceUsageStats> combined = new HashMap<String, IndexSpaceUsageStats>();
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object r = shardsResponses.get(i);
            if (r instanceof AnalyzeSpaceUsageShardResponse) {
                ++successfulShards;
                AnalyzeSpaceUsageShardResponse resp = (AnalyzeSpaceUsageShardResponse)r;
                combined.compute(resp.getIndex(), (k, v) -> v == null ? resp.stats : v.add(resp.stats));
                continue;
            }
            if (r instanceof DefaultShardOperationFailedException) {
                shardFailures.add((DefaultShardOperationFailedException)r);
                continue;
            }
            assert (false) : "unknown response [" + r + "]";
            throw new IllegalStateException("unknown response [" + r + "]");
        }
        return new AnalyzeIndexSpaceUsageResponse(shardsResponses.length(), successfulShards, shardFailures.size(), shardFailures, combined);
    }

    @Override
    protected GroupShardsIterator<ShardIterator> shards(ClusterState clusterState, AnalyzeIndexSpaceUsageRequest request, String[] concreteIndices) {
        GroupShardsIterator<ShardIterator> groups = this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, null, null);
        for (ShardIterator group : groups) {
            if (group.size() != 0) continue;
            throw new NoShardAvailableActionException(group.shardId());
        }
        return groups;
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, AnalyzeIndexSpaceUsageRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, AnalyzeIndexSpaceUsageRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }
}

