/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.exists.indices;

import java.io.IOException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.easysearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.action.support.master.TransportMasterNodeReadAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.IndexNotFoundException;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportIndicesExistsAction
extends TransportMasterNodeReadAction<IndicesExistsRequest, IndicesExistsResponse> {
    @Inject
    public TransportIndicesExistsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/exists", transportService, clusterService, threadPool, actionFilters, IndicesExistsRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected IndicesExistsResponse read(StreamInput in) throws IOException {
        return new IndicesExistsResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesExistsRequest request, ClusterState state) {
        IndicesOptions indicesOptions = IndicesOptions.fromOptions(true, true, request.indicesOptions().expandWildcardsOpen(), request.indicesOptions().expandWildcardsClosed());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, request.indices()));
    }

    @Override
    protected void masterOperation(IndicesExistsRequest request, ClusterState state, ActionListener<IndicesExistsResponse> listener) {
        boolean exists;
        try {
            this.indexNameExpressionResolver.concreteIndexNames(state, request);
            exists = true;
        }
        catch (IndexNotFoundException e) {
            exists = false;
        }
        listener.onResponse(new IndicesExistsResponse(exists));
    }
}

