/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.easysearch.action.admin.indices.stats.FieldUsageShardResponse;
import org.easysearch.action.admin.indices.stats.FieldUsageTrackerRequest;
import org.easysearch.action.admin.indices.stats.FieldUsageTrackerResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.DefaultShardOperationFailedException;
import org.easysearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.routing.ShardRouting;
import org.easysearch.cluster.routing.ShardsIterator;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.index.shard.ShardId;
import org.easysearch.indices.IndicesService;
import org.easysearch.transport.TransportService;

public class TransportFieldUsageAction
extends TransportBroadcastByNodeAction<FieldUsageTrackerRequest, FieldUsageTrackerResponse, FieldUsageShardResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportFieldUsageAction(ClusterService clusterService, TransportService transportService, IndicesService indexServices, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/field_usage_stats", clusterService, transportService, actionFilters, indexNameExpressionResolver, FieldUsageTrackerRequest::new, "same");
        this.indicesService = indexServices;
    }

    @Override
    protected FieldUsageShardResponse readShardResult(StreamInput in) throws IOException {
        return new FieldUsageShardResponse(in);
    }

    @Override
    protected FieldUsageTrackerResponse newResponse(FieldUsageTrackerRequest request, int totalShards, int successfulShards, int failedShards, List<FieldUsageShardResponse> fieldUsages, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        HashMap<String, List<FieldUsageShardResponse>> combined = new HashMap<String, List<FieldUsageShardResponse>>();
        for (FieldUsageShardResponse response : fieldUsages) {
            combined.computeIfAbsent(response.shardRouting.shardId().getIndexName(), i -> new ArrayList()).add(response);
        }
        return new FieldUsageTrackerResponse(totalShards, successfulShards, shardFailures.size(), shardFailures, combined);
    }

    @Override
    protected FieldUsageTrackerRequest readRequestFrom(StreamInput in) throws IOException {
        return new FieldUsageTrackerRequest(in);
    }

    @Override
    protected FieldUsageShardResponse shardOperation(FieldUsageTrackerRequest request, ShardRouting shardRouting) {
        ShardId shardId = shardRouting.shardId();
        IndexShard shard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
        return new FieldUsageShardResponse(shard.getShardUuid(), shardRouting, shard.getShardCreationTime(), shard.fieldUsageStats(request.fields()));
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, FieldUsageTrackerRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allActiveShards(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, FieldUsageTrackerRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, FieldUsageTrackerRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }
}

