/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.upgrade.get;

import java.io.IOException;
import java.util.List;
import org.easysearch.Version;
import org.easysearch.action.admin.indices.upgrade.get.ShardUpgradeStatus;
import org.easysearch.action.admin.indices.upgrade.get.UpgradeStatusRequest;
import org.easysearch.action.admin.indices.upgrade.get.UpgradeStatusResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.DefaultShardOperationFailedException;
import org.easysearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.routing.ShardRouting;
import org.easysearch.cluster.routing.ShardsIterator;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.IndexService;
import org.easysearch.index.engine.Segment;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.indices.IndicesService;
import org.easysearch.transport.TransportService;

public class TransportUpgradeStatusAction
extends TransportBroadcastByNodeAction<UpgradeStatusRequest, UpgradeStatusResponse, ShardUpgradeStatus> {
    private final IndicesService indicesService;

    @Inject
    public TransportUpgradeStatusAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/upgrade", clusterService, transportService, actionFilters, indexNameExpressionResolver, UpgradeStatusRequest::new, "management");
        this.indicesService = indicesService;
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, UpgradeStatusRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allShards(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, UpgradeStatusRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, UpgradeStatusRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    @Override
    protected ShardUpgradeStatus readShardResult(StreamInput in) throws IOException {
        return new ShardUpgradeStatus(in);
    }

    @Override
    protected UpgradeStatusResponse newResponse(UpgradeStatusRequest request, int totalShards, int successfulShards, int failedShards, List<ShardUpgradeStatus> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new UpgradeStatusResponse(responses.toArray(new ShardUpgradeStatus[responses.size()]), totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected UpgradeStatusRequest readRequestFrom(StreamInput in) throws IOException {
        return new UpgradeStatusRequest(in);
    }

    @Override
    protected ShardUpgradeStatus shardOperation(UpgradeStatusRequest request, ShardRouting shardRouting) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        List<Segment> segments = indexShard.segments(false);
        long total_bytes = 0L;
        long to_upgrade_bytes = 0L;
        long to_upgrade_bytes_ancient = 0L;
        for (Segment seg : segments) {
            total_bytes += seg.sizeInBytes;
            if (seg.version.major != Version.CURRENT.luceneVersion.major) {
                to_upgrade_bytes_ancient += seg.sizeInBytes;
                to_upgrade_bytes += seg.sizeInBytes;
                continue;
            }
            if (seg.version.minor == Version.CURRENT.luceneVersion.minor) continue;
            to_upgrade_bytes += seg.sizeInBytes;
        }
        return new ShardUpgradeStatus(indexShard.routingEntry(), total_bytes, to_upgrade_bytes, to_upgrade_bytes_ancient);
    }
}

