/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.bulk;

import java.io.IOException;
import org.easysearch.CompatibleESVersion;
import org.easysearch.Version;
import org.easysearch.action.DocWriteResponse;
import org.easysearch.action.bulk.BulkItemResponse;
import org.easysearch.action.support.WriteResponse;
import org.easysearch.action.support.replication.ReplicationResponse;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.index.shard.ShardId;

public class BulkShardResponse
extends ReplicationResponse
implements WriteResponse {
    private static final Version COMPACT_SHARD_ID_VERSION = CompatibleESVersion.V_7_10_2;
    private final ShardId shardId;
    private final BulkItemResponse[] responses;

    BulkShardResponse(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.responses = in.readArray(in.getVersion().onOrAfter(COMPACT_SHARD_ID_VERSION) ? i -> new BulkItemResponse(this.shardId, i) : BulkItemResponse::new, BulkItemResponse[]::new);
    }

    public BulkShardResponse(ShardId shardId, BulkItemResponse[] responses) {
        this.shardId = shardId;
        this.responses = responses;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BulkItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public void setForcedRefresh(boolean forcedRefresh) {
        for (BulkItemResponse response : this.responses) {
            Object r = response.getResponse();
            if (r == null) continue;
            ((DocWriteResponse)r).setForcedRefresh(forcedRefresh);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeArray(out.getVersion().onOrAfter(COMPACT_SHARD_ID_VERSION) ? (o, item) -> item.writeThin(out) : (o, item) -> item.writeTo(o), this.responses);
    }
}

