/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.ingest;

import java.io.IOException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ingest.GetPipelineRequest;
import org.easysearch.action.ingest.GetPipelineResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.TransportMasterNodeReadAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.ingest.IngestService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class GetPipelineTransportAction
extends TransportMasterNodeReadAction<GetPipelineRequest, GetPipelineResponse> {
    @Inject
    public GetPipelineTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/ingest/pipeline/get", transportService, clusterService, threadPool, actionFilters, GetPipelineRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected GetPipelineResponse read(StreamInput in) throws IOException {
        return new GetPipelineResponse(in);
    }

    @Override
    protected void masterOperation(GetPipelineRequest request, ClusterState state, ActionListener<GetPipelineResponse> listener) throws Exception {
        listener.onResponse(new GetPipelineResponse(IngestService.getPipelines(state, request.getIds())));
    }

    @Override
    protected ClusterBlockException checkBlock(GetPipelineRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

