/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.main;

import org.easysearch.Build;
import org.easysearch.Version;
import org.easysearch.action.ActionListener;
import org.easysearch.action.main.MainRequest;
import org.easysearch.action.main.MainResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.HandledTransportAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.settings.Settings;
import org.easysearch.http.HttpTransportSettings;
import org.easysearch.node.Node;
import org.easysearch.tasks.Task;
import org.easysearch.transport.TransportService;

public class TransportMainAction
extends HandledTransportAction<MainRequest, MainResponse> {
    private final String nodeName;
    private final ClusterService clusterService;
    private final boolean esVersion;

    @Inject
    public TransportMainAction(Settings settings, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService) {
        super("cluster:monitor/main", transportService, actionFilters, MainRequest::new);
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
        this.clusterService = clusterService;
        this.esVersion = HttpTransportSettings.ELASTICSEARCH_API_COMPATIBILITY.get(settings);
    }

    @Override
    protected void doExecute(Task task, MainRequest request, ActionListener<MainResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        listener.onResponse(new MainResponse(this.nodeName, Version.CURRENT, clusterState.getClusterName(), clusterState.metadata().clusterUUID(), Build.CURRENT, this.esVersion));
    }
}

