/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.search;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.FixedBitSet;
import org.easysearch.action.ActionListener;
import org.easysearch.action.search.AbstractSearchAsyncAction;
import org.easysearch.action.search.SearchActionListener;
import org.easysearch.action.search.SearchPhase;
import org.easysearch.action.search.SearchPhaseContext;
import org.easysearch.action.search.SearchPhaseResults;
import org.easysearch.action.search.SearchRequest;
import org.easysearch.action.search.SearchResponse;
import org.easysearch.action.search.SearchShardIterator;
import org.easysearch.action.search.SearchTask;
import org.easysearch.action.search.SearchTransportService;
import org.easysearch.action.search.TransportSearchAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.routing.GroupShardsIterator;
import org.easysearch.common.lease.Releasable;
import org.easysearch.search.SearchService;
import org.easysearch.search.SearchShardTarget;
import org.easysearch.search.builder.SearchSourceBuilder;
import org.easysearch.search.internal.AliasFilter;
import org.easysearch.search.sort.FieldSortBuilder;
import org.easysearch.search.sort.MinAndMax;
import org.easysearch.search.sort.SortOrder;
import org.easysearch.transport.Transport;

final class CanMatchPreFilterSearchPhase
extends AbstractSearchAsyncAction<SearchService.CanMatchResponse> {
    private final Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory;
    private final GroupShardsIterator<SearchShardIterator> shardsIts;

    CanMatchPreFilterSearchPhase(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory, SearchResponse.Clusters clusters) {
        super("can_match", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterState, task, new CanMatchSearchPhaseResults(shardsIts.size()), shardsIts.size(), clusters);
        this.phaseFactory = phaseFactory;
        this.shardsIts = shardsIts;
    }

    @Override
    public void addReleasable(Releasable releasable) {
        throw new RuntimeException("cannot add releasable in " + this.getName() + " phase");
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<SearchService.CanMatchResponse> listener) {
        this.getSearchTransport().sendCanMatch(this.getConnection(shard.getClusterAlias(), shard.getNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<SearchService.CanMatchResponse> results, SearchPhaseContext context) {
        return this.phaseFactory.apply(this.getIterator((CanMatchSearchPhaseResults)results, this.shardsIts));
    }

    private GroupShardsIterator<SearchShardIterator> getIterator(CanMatchSearchPhaseResults results, GroupShardsIterator<SearchShardIterator> shardsIts) {
        int cardinality = results.getNumPossibleMatches();
        FixedBitSet possibleMatches = results.getPossibleMatches();
        if (cardinality == 0) {
            possibleMatches.set(0);
        }
        SearchSourceBuilder source = this.getRequest().source();
        int i = 0;
        for (SearchShardIterator iter : shardsIts) {
            if (possibleMatches.get(i++)) {
                iter.reset();
                continue;
            }
            iter.resetAndSkip();
        }
        if (!CanMatchPreFilterSearchPhase.shouldSortShards(results.minAndMaxes)) {
            return shardsIts;
        }
        FieldSortBuilder fieldSort = FieldSortBuilder.getPrimaryFieldSortOrNull(source);
        return new GroupShardsIterator<SearchShardIterator>(CanMatchPreFilterSearchPhase.sortShards(shardsIts, results.minAndMaxes, fieldSort.order()));
    }

    private static List<SearchShardIterator> sortShards(GroupShardsIterator<SearchShardIterator> shardsIts, MinAndMax<?>[] minAndMaxes, SortOrder order) {
        return IntStream.range(0, shardsIts.size()).boxed().sorted(CanMatchPreFilterSearchPhase.shardComparator(shardsIts, minAndMaxes, order)).map(shardsIts::get).collect(Collectors.toList());
    }

    private static boolean shouldSortShards(MinAndMax<?>[] minAndMaxes) {
        Class<?> clazz = null;
        for (MinAndMax<?> minAndMax : minAndMaxes) {
            if (clazz == null) {
                clazz = minAndMax == null ? null : minAndMax.getMin().getClass();
                continue;
            }
            if (minAndMax == null || clazz == minAndMax.getMin().getClass()) continue;
            return false;
        }
        return clazz != null;
    }

    private static Comparator<Integer> shardComparator(GroupShardsIterator<SearchShardIterator> shardsIts, MinAndMax<?>[] minAndMaxes, SortOrder order) {
        Comparator<Integer> comparator = Comparator.comparing(index -> minAndMaxes[index], MinAndMax.getComparator(order));
        return comparator.thenComparing(index -> ((SearchShardIterator)shardsIts.get((int)index)).shardId());
    }

    private static final class CanMatchSearchPhaseResults
    extends SearchPhaseResults<SearchService.CanMatchResponse> {
        private final FixedBitSet possibleMatches;
        private final MinAndMax<?>[] minAndMaxes;
        private int numPossibleMatches;

        CanMatchSearchPhaseResults(int size) {
            super(size);
            this.possibleMatches = new FixedBitSet(size);
            this.minAndMaxes = new MinAndMax[size];
        }

        @Override
        void consumeResult(SearchService.CanMatchResponse result, Runnable next) {
            try {
                this.consumeResult(result.getShardIndex(), result.canMatch(), result.estimatedMinAndMax());
            }
            finally {
                next.run();
            }
        }

        @Override
        boolean hasResult(int shardIndex) {
            return false;
        }

        @Override
        void consumeShardFailure(int shardIndex) {
            this.consumeResult(shardIndex, true, null);
        }

        synchronized void consumeResult(int shardIndex, boolean canMatch, MinAndMax<?> minAndMax) {
            if (canMatch) {
                this.possibleMatches.set(shardIndex);
                ++this.numPossibleMatches;
            }
            this.minAndMaxes[shardIndex] = minAndMax;
        }

        synchronized int getNumPossibleMatches() {
            return this.numPossibleMatches;
        }

        synchronized FixedBitSet getPossibleMatches() {
            return this.possibleMatches;
        }

        @Override
        Stream<SearchService.CanMatchResponse> getSuccessfulResults() {
            return Stream.empty();
        }
    }
}

